/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultBooleanType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.model.impl.DefaultVoidType;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExecutionType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.operation.RouteModel;
import org.mule.runtime.api.meta.model.operation.RouterModel;
import org.mule.runtime.api.meta.model.operation.ScopeModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.processor.LoggerMessageProcessor;
import org.mule.runtime.core.api.source.SchedulingStrategy;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.routing.AggregationStrategy;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.resources.MuleExtensionModelProvider;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class CoreExtensionModelTestCase
extends AbstractMuleContextTestCase {
    private static final ErrorModel errorMuleAny = ErrorModelBuilder.newError((String)"ANY", (String)"MULE").build();
    private static ExtensionModel coreExtensionModel = MuleExtensionModelProvider.getExtensionModel();

    @Test
    public void consistentWithManifest() {
        Assert.assertThat((Object)coreExtensionModel.getName(), (Matcher)Matchers.is((Object)MuleManifest.getProductName()));
        Assert.assertThat((Object)coreExtensionModel.getDescription(), (Matcher)Matchers.is((Object)(MuleManifest.getProductDescription() + ": Core components")));
        Assert.assertThat((Object)coreExtensionModel.getVersion(), (Matcher)Matchers.is((Object)MuleManifest.getProductVersion()));
        Assert.assertThat((Object)coreExtensionModel.getVendor(), (Matcher)Matchers.is((Object)MuleManifest.getVendorName()));
        Assert.assertThat((Object)coreExtensionModel.getCategory(), (Matcher)Matchers.is((Object)Category.COMMUNITY));
        Assert.assertThat((Object)coreExtensionModel.getMinMuleVersion(), (Matcher)Matchers.is((Object)new MuleVersion("4.0.0-BETA-SNAPSHOT")));
    }

    @Test
    public void consistentWithSchema() {
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getPrefix(), (Matcher)Matchers.is((Object)"mule"));
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getNamespace(), (Matcher)Matchers.is((Object)"http://www.mulesoft.org/schema/mule/core"));
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getSchemaLocation(), (Matcher)Matchers.is((Object)"http://www.mulesoft.org/schema/mule/core/current/mule.xsd"));
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getSchemaVersion(), (Matcher)Matchers.is((Object)"4.0.0-BETA-SNAPSHOT"));
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getXsdFileName(), (Matcher)Matchers.is((Object)"mule.xsd"));
    }

    @Test
    public void otherModels() {
        Assert.assertThat((Object)coreExtensionModel.getResources(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getSubTypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        SubTypesModel subTypesModel = (SubTypesModel)coreExtensionModel.getSubTypes().iterator().next();
        Assert.assertThat((Object)((TypeIdAnnotation)subTypesModel.getBaseType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)SchedulingStrategy.class.getName()));
        Assert.assertThat((Object)subTypesModel.getSubTypes(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Iterator iterator = subTypesModel.getSubTypes().iterator();
        DefaultObjectType ffSchedulerType = (DefaultObjectType)iterator.next();
        Assert.assertThat((Object)ffSchedulerType.getFields(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("frequency").get()).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("frequency").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("startDelay").get()).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("startDelay").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("timeUnit").get()).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("timeUnit").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        DefaultObjectType cronSchedulerType = (DefaultObjectType)iterator.next();
        Assert.assertThat((Object)cronSchedulerType.getFields(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)((ObjectFieldType)cronSchedulerType.getFieldByName("expression").get()).isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ObjectFieldType)cronSchedulerType.getFieldByName("expression").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ObjectFieldType)cronSchedulerType.getFieldByName("timeZone").get()).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ObjectFieldType)cronSchedulerType.getFieldByName("timeZone").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)coreExtensionModel.getExternalLibraryModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getImportedTypes(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getConfigurationModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getOperationModels(), (Matcher)IsCollectionWithSize.hasSize((int)16));
        Assert.assertThat((Object)coreExtensionModel.getConnectionProviders(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getErrorModels(), (Matcher)IsCollectionContaining.hasItem((Object)ErrorModelBuilder.newError((String)"TRANSFORMATION", (String)"CORE").withParent(ErrorModelBuilder.newError((String)"TRANSFORMATION", (String)"MULE").withParent(errorMuleAny).build()).build()));
        Assert.assertThat((Object)coreExtensionModel.getErrorModels(), (Matcher)IsCollectionContaining.hasItem((Object)ErrorModelBuilder.newError((String)"CORRELATION_TIMEOUT", (String)"CORE").withParent(ErrorModelBuilder.newError((String)"ANY", (String)"CORE").withParent(errorMuleAny).build()).build()));
        Assert.assertThat((Object)coreExtensionModel.getSourceModels(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)coreExtensionModel.getModelProperties(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getTypes(), (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    public void scheduler() {
        SourceModel schedulerModel = (SourceModel)coreExtensionModel.getSourceModel("scheduler").get();
        Assert.assertThat((Object)schedulerModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)schedulerModel.hasResponse(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)schedulerModel.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)schedulerModel.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)schedulerModel.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)schedulerModel.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        List paramModels = schedulerModel.getAllParameterModels();
        Assert.assertThat((Object)paramModels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.assertSchedulingStrategy((ParameterModel)paramModels.get(0));
    }

    @Test
    public void logger() {
        OperationModel loggerModel = (OperationModel)coreExtensionModel.getOperationModel("logger").get();
        Assert.assertThat((Object)loggerModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)loggerModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertOutputSameAsInput(loggerModel);
        List paramModels = loggerModel.getAllParameterModels();
        Assert.assertThat((Object)paramModels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getName(), (Matcher)Matchers.is((Object)"message"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)((ParameterModel)paramModels.get(0)).getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)String.class.getName()));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getName(), (Matcher)Matchers.is((Object)"category"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)((ParameterModel)paramModels.get(1)).getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)String.class.getName()));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getName(), (Matcher)Matchers.is((Object)"level"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)((ParameterModel)paramModels.get(2)).getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)(LoggerMessageProcessor.class.getName() + "." + LoggerMessageProcessor.LogLevel.class.getSimpleName())));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void transform() {
        OperationModel transformModel = (OperationModel)coreExtensionModel.getOperationModel("transform").get();
        Assert.assertThat((Object)transformModel.getErrorModels(), (Matcher)IsCollectionContaining.hasItem((Object)ErrorModelBuilder.newError((String)"TRANSFORMATION", (String)"CORE").withParent(ErrorModelBuilder.newError((String)"TRANSFORMATION", (String)"MULE").withParent(errorMuleAny).build()).build()));
        Assert.assertThat((Object)transformModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_INTENSIVE));
        Assert.assertThat((Object)transformModel.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultAnyType.class));
        Assert.assertThat((Object)transformModel.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)transformModel.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)transformModel.getOutputAttributes().getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)Attributes.class.getName()));
        Assert.assertThat((Object)transformModel.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        List paramGroupModels = transformModel.getParameterGroupModels();
        Assert.assertThat((Object)paramGroupModels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)transformModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((ParameterGroupModel)paramGroupModels.get(0)).getName(), (Matcher)Matchers.is((Object)"Message"));
        List paramModels = ((ParameterGroupModel)paramGroupModels.get(0)).getParameterModels();
        Assert.assertThat((Object)paramModels.size(), (Matcher)Matchers.is((Object)2));
        ParameterModel setPayload = (ParameterModel)paramModels.get(0);
        Assert.assertThat((Object)setPayload.getName(), (Matcher)Matchers.is((Object)"setPayload"));
        Assert.assertThat((Object)setPayload.getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
        Assert.assertThat((Object)ExtensionMetadataTypeUtils.getId((MetadataType)setPayload.getType()), (Matcher)Matchers.is((Object)"com.mulesoft.mule.runtime.processor.SetPayloadTransformationTarget"));
        Assert.assertThat((Object)setPayload.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)setPayload.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)setPayload.getRole(), (Matcher)Matchers.is((Object)ParameterRole.BEHAVIOUR));
        this.assertScriptAndResource((ObjectType)setPayload.getType());
        ParameterModel setAttributes = (ParameterModel)paramModels.get(1);
        Assert.assertThat((Object)setAttributes.getName(), (Matcher)Matchers.is((Object)"setAttributes"));
        Assert.assertThat((Object)setAttributes.getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
        Assert.assertThat((Object)ExtensionMetadataTypeUtils.getId((MetadataType)setAttributes.getType()), (Matcher)Matchers.is((Object)"com.mulesoft.mule.runtime.processor.SetAttributesTransformationTarget"));
        Assert.assertThat((Object)setAttributes.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)setAttributes.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)setAttributes.getRole(), (Matcher)Matchers.is((Object)ParameterRole.BEHAVIOUR));
        this.assertScriptAndResource((ObjectType)setAttributes.getType());
        Assert.assertThat((Object)((ParameterGroupModel)paramGroupModels.get(1)).getName(), (Matcher)Matchers.is((Object)"Set Variables"));
        ParameterModel setVariables = (ParameterModel)((ParameterGroupModel)paramGroupModels.get(1)).getParameterModels().get(0);
        Assert.assertThat((Object)setVariables.getName(), (Matcher)Matchers.is((Object)"setVariables"));
        Assert.assertThat((Object)setVariables.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ArrayType.class)));
        Assert.assertThat((Object)((ArrayType)setVariables.getType()).getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
        Assert.assertThat((Object)ExtensionMetadataTypeUtils.getId((MetadataType)((ArrayType)setVariables.getType()).getType()), (Matcher)Matchers.is((Object)"com.mulesoft.mule.runtime.processor.SetVariableTransformationTarget"));
        Assert.assertThat((Object)setVariables.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)setVariables.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)setVariables.getRole(), (Matcher)Matchers.is((Object)ParameterRole.BEHAVIOUR));
        ObjectType setVariableType = (ObjectType)((ArrayType)setVariables.getType()).getType();
        this.assertScriptAndResource(setVariableType);
        Optional<ObjectFieldType> variableName = setVariableType.getFields().stream().filter(field -> field.getKey().getName().getLocalPart().equals("variableName")).findFirst();
        if (variableName.isPresent()) {
            Assert.assertThat((Object)variableName.get().getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        } else {
            Assert.fail((String)("Missing parameter [variableName] in type: " + ExtensionMetadataTypeUtils.getId((MetadataType)setVariableType)));
        }
    }

    private void assertScriptAndResource(ObjectType parameter) {
        Collection fields = parameter.getFields();
        Optional<ObjectFieldType> script = fields.stream().filter(field -> field.getKey().getName().getLocalPart().equals("script")).findFirst();
        if (script.isPresent()) {
            Assert.assertThat((Object)script.get().getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
            Assert.assertThat((Object)((LayoutTypeAnnotation)script.get().getAnnotation(LayoutTypeAnnotation.class).get()).isText(), (Matcher)Matchers.is((Object)true));
        } else {
            Assert.fail((String)("Missing parameter [script] in type: " + ExtensionMetadataTypeUtils.getId((MetadataType)parameter)));
        }
        Optional<ObjectFieldType> resource = fields.stream().filter(field -> field.getKey().getName().getLocalPart().equals("resource")).findFirst();
        if (resource.isPresent()) {
            Assert.assertThat((Object)resource.get().getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        } else {
            Assert.fail((String)("Missing parameter [resource] in type: " + ExtensionMetadataTypeUtils.getId((MetadataType)parameter)));
        }
    }

    @Test
    public void splitter() {
        OperationModel splitterModel = (OperationModel)coreExtensionModel.getOperationModel("splitter").get();
        Assert.assertThat((Object)splitterModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)splitterModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_INTENSIVE));
        this.assertComponentDeterminesOutput(splitterModel);
        Assert.assertThat((Object)splitterModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.assertMultiPayload((ParameterModel)splitterModel.getAllParameterModels().get(0), "payload", ExpressionSupport.REQUIRED);
        this.assertTarget((ParameterModel)splitterModel.getAllParameterModels().get(1));
    }

    @Test
    public void collectionSplitter() {
        OperationModel collectionSplitterModel = (OperationModel)coreExtensionModel.getOperationModel("collectionSplitter").get();
        Assert.assertThat((Object)collectionSplitterModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)collectionSplitterModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertComponentDeterminesOutput(collectionSplitterModel);
        Assert.assertThat((Object)collectionSplitterModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.assertMultiPayload((ParameterModel)collectionSplitterModel.getAllParameterModels().get(0), "payload", ExpressionSupport.SUPPORTED);
        this.assertTarget((ParameterModel)collectionSplitterModel.getAllParameterModels().get(1));
    }

    @Test
    public void collectionAggregator() {
        OperationModel collectionAggregatorModel = (OperationModel)coreExtensionModel.getOperationModel("collectionAggregator").get();
        Assert.assertThat((Object)collectionAggregatorModel.getErrorModels(), (Matcher)IsCollectionContaining.hasItem((Object)ErrorModelBuilder.newError((String)"CORRELATION_TIMEOUT", (String)"CORE").withParent(ErrorModelBuilder.newError((String)"ANY", (String)"CORE").withParent(errorMuleAny).build()).build()));
        Assert.assertThat((Object)collectionAggregatorModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.BLOCKING));
        Assert.assertThat((Object)collectionAggregatorModel.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultArrayType.class));
        Assert.assertThat((Object)collectionAggregatorModel.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)collectionAggregatorModel.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)collectionAggregatorModel.getOutputAttributes().getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)NullAttributes.class.getName()));
        Assert.assertThat((Object)collectionAggregatorModel.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        List paramModels = collectionAggregatorModel.getAllParameterModels();
        Assert.assertThat((Object)paramModels, (Matcher)IsCollectionWithSize.hasSize((int)8));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getName(), (Matcher)Matchers.is((Object)"timeout"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)((ParameterModel)paramModels.get(0)).getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)Long.TYPE.getName()));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getName(), (Matcher)Matchers.is((Object)"failOnTimeout"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getType(), (Matcher)Matchers.instanceOf(DefaultBooleanType.class));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getName(), (Matcher)Matchers.is((Object)"processedGroupsObjectStore"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)((ParameterModel)paramModels.get(2)).getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)ObjectStore.class.getName()));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(3)).getName(), (Matcher)Matchers.is((Object)"eventGroupsObjectStore"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(3)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(3)).getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)((ParameterModel)paramModels.get(3)).getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)ObjectStore.class.getName()));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(3)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(4)).getName(), (Matcher)Matchers.is((Object)"persistentStores"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(4)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(4)).getType(), (Matcher)Matchers.instanceOf(DefaultBooleanType.class));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(4)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(5)).getName(), (Matcher)Matchers.is((Object)"storePrefix"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(5)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(5)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(5)).isRequired(), (Matcher)Matchers.is((Object)true));
        this.assertPayload((ParameterModel)paramModels.get(6));
        this.assertTarget((ParameterModel)paramModels.get(7));
    }

    @Test
    public void foreach() {
        ScopeModel foreachModel = (ScopeModel)coreExtensionModel.getOperationModel("foreach").get();
        Assert.assertThat((Object)foreachModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)foreachModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertComponentDeterminesOutput((OperationModel)foreachModel);
        Assert.assertThat((Object)foreachModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)5));
        this.assertMultiPayload((ParameterModel)foreachModel.getAllParameterModels().get(0), "collection", ExpressionSupport.SUPPORTED);
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"batchSize"));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(1)).getType(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"rootMessageVariableName"));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(2)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(2)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(2)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"counterVariableName"));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(3)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(3)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)foreachModel.getAllParameterModels().get(3)).isRequired(), (Matcher)Matchers.is((Object)false));
        this.assertTarget((ParameterModel)foreachModel.getAllParameterModels().get(4));
    }

    @Test
    public void flowRef() {
        OperationModel flowRefModel = (OperationModel)coreExtensionModel.getOperationModel("flowRef").get();
        this.assertAssociatedProcessorsChangeOutput(flowRefModel);
        Assert.assertThat((Object)flowRefModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((ParameterModel)flowRefModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"name"));
        Assert.assertThat((Object)((ParameterModel)flowRefModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)flowRefModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)flowRefModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)true));
        this.assertPayload((ParameterModel)flowRefModel.getAllParameterModels().get(1));
        this.assertTarget((ParameterModel)flowRefModel.getAllParameterModels().get(2));
    }

    @Test
    public void filter() {
        OperationModel filterModel = (OperationModel)coreExtensionModel.getOperationModel("filter").get();
        this.assertOutputSameAsInput(filterModel);
        Assert.assertThat((Object)filterModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.assertPayload((ParameterModel)filterModel.getAllParameterModels().get(1));
    }

    @Test
    public void idempotentMessageValidator() {
        OperationModel filterModel = (OperationModel)coreExtensionModel.getOperationModel("idempotentMessageValidator").get();
        this.assertOutputSameAsInput(filterModel);
        Assert.assertThat((Object)filterModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"idExpression"));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"valueExpression"));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(1)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"objectStore"));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(2)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(2)).getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(2)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"storePrefix"));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void choice() {
        RouterModel choiceModel = (RouterModel)coreExtensionModel.getOperationModel("choice").get();
        Assert.assertThat((Object)choiceModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)choiceModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertAssociatedProcessorsChangeOutput((OperationModel)choiceModel);
        Assert.assertThat((Object)choiceModel.getAllParameterModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)choiceModel.getRouteModels(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        RouteModel whenRouteModel = (RouteModel)choiceModel.getRouteModels().get(0);
        Assert.assertThat((Object)whenRouteModel.getName(), (Matcher)Matchers.is((Object)"when"));
        Assert.assertThat((Object)whenRouteModel.getMinOccurs(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)whenRouteModel.getMaxOccurs(), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)whenRouteModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((ParameterModel)whenRouteModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"expression"));
        Assert.assertThat((Object)((ParameterModel)whenRouteModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)whenRouteModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultBooleanType.class));
        Assert.assertThat((Object)((ParameterModel)whenRouteModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)false));
        RouteModel otherwiseRouteModel = (RouteModel)choiceModel.getRouteModels().get(1);
        Assert.assertThat((Object)otherwiseRouteModel.getName(), (Matcher)Matchers.is((Object)"otherwise"));
        Assert.assertThat((Object)otherwiseRouteModel.getMinOccurs(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(otherwiseRouteModel.getMaxOccurs().get(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)otherwiseRouteModel.getAllParameterModels(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void scatterGather() {
        RouterModel scatterGatherModel = (RouterModel)coreExtensionModel.getOperationModel("scatterGather").get();
        Assert.assertThat((Object)scatterGatherModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)scatterGatherModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertComponentDeterminesOutput((OperationModel)scatterGatherModel);
        Assert.assertThat((Object)scatterGatherModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"parallel"));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultBooleanType.class));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"timeout"));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(1)).getType(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"custom-aggregation-strategy"));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)AggregationStrategy.class.getName()));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)scatterGatherModel.getRouteModels(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        RouteModel routeModel = (RouteModel)scatterGatherModel.getRouteModels().get(0);
        Assert.assertThat((Object)routeModel.getName(), (Matcher)Matchers.is((Object)"route"));
        Assert.assertThat((Object)routeModel.getMinOccurs(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)routeModel.getMaxOccurs(), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)routeModel.getAllParameterModels(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void async() {
        ScopeModel asyncModel = (ScopeModel)coreExtensionModel.getOperationModel("async").get();
        Assert.assertThat((Object)asyncModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)asyncModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertOutputSameAsInput((OperationModel)asyncModel);
        Assert.assertThat((Object)asyncModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void tryScope() {
        ScopeModel tryModel = (ScopeModel)coreExtensionModel.getOperationModel("try").get();
        Assert.assertThat((Object)tryModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)tryModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.BLOCKING));
        this.assertAssociatedProcessorsChangeOutput((OperationModel)tryModel);
        List allParameterModels = tryModel.getAllParameterModels();
        Assert.assertThat((Object)allParameterModels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterModel action = (ParameterModel)allParameterModels.get(0);
        Assert.assertThat((Object)action.getName(), (Matcher)Matchers.is((Object)"transactionalAction"));
        Assert.assertThat((Object)action.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)action.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)action.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel type = (ParameterModel)allParameterModels.get(1);
        Assert.assertThat((Object)type.getName(), (Matcher)Matchers.is((Object)"transactionType"));
        Assert.assertThat((Object)type.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)type.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)type.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void errorHandler() {
        ScopeModel errorHandlerModel = (ScopeModel)coreExtensionModel.getOperationModel("errorHandler").get();
        Assert.assertThat((Object)errorHandlerModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)errorHandlerModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertAssociatedProcessorsChangeOutput((OperationModel)errorHandlerModel);
        List allParameterModels = errorHandlerModel.getAllParameterModels();
        Assert.assertThat((Object)allParameterModels, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void onErrorContinue() {
        this.verifyOnError("onErrorContinue");
    }

    @Test
    public void onErrorPropagate() {
        this.verifyOnError("onErrorPropagate");
    }

    void verifyOnError(String name) {
        ScopeModel continueModel = (ScopeModel)coreExtensionModel.getOperationModel(name).get();
        Assert.assertThat((Object)continueModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)continueModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertAssociatedProcessorsChangeOutput((OperationModel)continueModel);
        List allParameterModels = continueModel.getAllParameterModels();
        Assert.assertThat((Object)allParameterModels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        ParameterModel type = (ParameterModel)allParameterModels.get(0);
        Assert.assertThat((Object)type.getName(), (Matcher)Matchers.is((Object)"type"));
        Assert.assertThat((Object)type.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(UnionType.class)));
        List types = ((UnionType)type.getType()).getTypes();
        Assert.assertThat((Object)types, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat(types.get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat(types.get(1), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)((EnumAnnotation)((MetadataType)types.get(1)).getAnnotation(EnumAnnotation.class).get()).getValues(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Object[]{"ANY", "REDELIVERY_EXHAUSTED", "TRANSFORMATION", "EXPRESSION", "SECURITY", "CLIENT_SECURITY", "SERVER_SECURITY", "ROUTING", "CONNECTIVITY", "RETRY_EXHAUSTED"}));
        Assert.assertThat((Object)type.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)type.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel when = (ParameterModel)allParameterModels.get(1);
        Assert.assertThat((Object)when.getName(), (Matcher)Matchers.is((Object)"when"));
        Assert.assertThat((Object)when.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)when.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)when.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel log = (ParameterModel)allParameterModels.get(2);
        Assert.assertThat((Object)log.getName(), (Matcher)Matchers.is((Object)"logException"));
        Assert.assertThat((Object)log.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultBooleanType.class)));
        Assert.assertThat((Object)log.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)log.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel notifications = (ParameterModel)allParameterModels.get(3);
        Assert.assertThat((Object)notifications.getName(), (Matcher)Matchers.is((Object)"enableNotifications"));
        Assert.assertThat((Object)notifications.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultBooleanType.class)));
        Assert.assertThat((Object)notifications.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)notifications.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)notifications.getDefaultValue(), (Matcher)Matchers.is((Object)"true"));
    }

    private void assertOutputSameAsInput(OperationModel model) {
        Assert.assertThat((Object)model.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultVoidType.class));
        Assert.assertThat((Object)model.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)model.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(DefaultVoidType.class));
        Assert.assertThat((Object)model.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
    }

    private void assertComponentDeterminesOutput(OperationModel model) {
        Assert.assertThat((Object)model.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultAnyType.class));
        Assert.assertThat((Object)model.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)model.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)model.getOutputAttributes().getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)NullAttributes.class.getName()));
        Assert.assertThat((Object)model.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
    }

    private void assertAssociatedProcessorsChangeOutput(OperationModel model) {
        Assert.assertThat((Object)model.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultAnyType.class));
        Assert.assertThat((Object)model.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)model.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)model.getOutputAttributes().getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)Attributes.class.getName()));
        Assert.assertThat((Object)model.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
    }

    private void assertPayload(ParameterModel payloadParameterModel) {
        Assert.assertThat((Object)payloadParameterModel.getName(), (Matcher)Matchers.is((Object)"payload"));
        Assert.assertThat((Object)payloadParameterModel.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)payloadParameterModel.getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)payloadParameterModel.getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)Object.class.getName()));
        Assert.assertThat((Object)payloadParameterModel.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    private void assertMultiPayload(ParameterModel payloadParameterModel, String payloadVariableName, ExpressionSupport expressionSupport) {
        Assert.assertThat((Object)payloadParameterModel.getName(), (Matcher)Matchers.is((Object)payloadVariableName));
        Assert.assertThat((Object)payloadParameterModel.getExpressionSupport(), (Matcher)Matchers.is((Object)expressionSupport));
        Assert.assertThat((Object)payloadParameterModel.getType(), (Matcher)Matchers.instanceOf(DefaultArrayType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)payloadParameterModel.getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)Iterable.class.getName()));
        Assert.assertThat((Object)payloadParameterModel.isRequired(), (Matcher)Matchers.is((Object)(expressionSupport == ExpressionSupport.REQUIRED ? 1 : 0)));
    }

    private void assertTarget(ParameterModel targetParameterModel) {
        Assert.assertThat((Object)targetParameterModel.getName(), (Matcher)Matchers.is((Object)"target"));
        Assert.assertThat((Object)targetParameterModel.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)targetParameterModel.getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)targetParameterModel.getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)String.class.getName()));
        Assert.assertThat((Object)targetParameterModel.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    private void assertSchedulingStrategy(ParameterModel paramModel) {
        Assert.assertThat((Object)paramModel.getName(), (Matcher)Matchers.is((Object)"schedulingStrategy"));
        Assert.assertThat((Object)paramModel.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)paramModel.getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)paramModel.isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((TypeIdAnnotation)paramModel.getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)SchedulingStrategy.class.getName()));
    }
}

