/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.extension.api.annotation.DataTypeParameters;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.DataTypeDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.reflections.ReflectionUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DataTypeDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationDeclaration annotatedOperation;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationDeclaration notAnnotatedOperation;
    private Method method = this.getAnnotatedMethod();
    private DataTypeDeclarationEnricher enricher = new DataTypeDeclarationEnricher();

    @Before
    @DataTypeParameters
    public void before() {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Arrays.asList(this.annotatedOperation, this.notAnnotatedOperation));
        Mockito.when((Object)this.annotatedOperation.getModelProperty(ImplementingTypeModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.annotatedOperation.getModelProperty(ImplementingMethodModelProperty.class)).thenReturn(Optional.of(new ImplementingMethodModelProperty(this.method)));
        ExtensionsTestUtils.mockParameters((ParameterizedDeclaration)this.annotatedOperation, new ParameterDeclaration[0]);
        Mockito.when((Object)this.notAnnotatedOperation.getModelProperty(ImplementingTypeModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.notAnnotatedOperation.getModelProperty(ImplementingMethodModelProperty.class)).thenReturn(Optional.empty());
        ExtensionsTestUtils.mockParameters((ParameterizedDeclaration)this.notAnnotatedOperation, new ParameterDeclaration[0]);
    }

    @Test
    public void enrichAnnotated() {
        this.enricher.enrich(this.extensionLoadingContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ParameterDeclaration.class);
        ((ParameterGroupDeclaration)Mockito.verify(this.annotatedOperation.getParameterGroups().get(0), (VerificationMode)Mockito.times((int)2))).addParameter((ParameterDeclaration)captor.capture());
        Assert.assertThat((Object)captor.getAllValues(), (Matcher)Matchers.hasSize((int)2));
        this.assertParameter((ParameterDeclaration)captor.getAllValues().get(0), "outputMimeType");
        this.assertParameter((ParameterDeclaration)captor.getAllValues().get(1), "outputEncoding");
    }

    @Test
    public void skipNotAnnotated() {
        this.enricher.enrich(this.extensionLoadingContext);
        ((ParameterGroupDeclaration)Mockito.verify(this.notAnnotatedOperation.getParameterGroups().get(0), (VerificationMode)Mockito.never())).addParameter((ParameterDeclaration)org.mockito.Matchers.any(ParameterDeclaration.class));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void voidOperation() {
        Mockito.when((Object)this.annotatedOperation.getModelProperty(ImplementingMethodModelProperty.class)).thenReturn(Optional.of(new ImplementingMethodModelProperty(this.getVoidAnnotatedMethod())));
        this.enricher.enrich(this.extensionLoadingContext);
    }

    private void assertParameter(ParameterDeclaration parameter, String name) {
        Assert.assertThat((Object)parameter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)name));
        Assert.assertThat((Object)parameter.getType(), (Matcher)CoreMatchers.equalTo((Object)ExtensionsTestUtils.toMetadataType(String.class)));
        Assert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parameter.getExpressionSupport(), (Matcher)CoreMatchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @DataTypeParameters
    public Object operationMethod() {
        return null;
    }

    private Method getAnnotatedMethod() {
        return (Method)ReflectionUtils.getMethods(((Object)((Object)this)).getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(DataTypeParameters.class), ReflectionUtils.withReturnType(Object.class)}).stream().findFirst().get();
    }

    private Method getVoidAnnotatedMethod() {
        return (Method)ReflectionUtils.getMethods(((Object)((Object)this)).getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(DataTypeParameters.class), ReflectionUtils.withReturnType(Void.TYPE)}).stream().findFirst().get();
    }
}

