/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ExportedTypesModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExportedTypesValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private SourceModel sourceModel;
    @Mock
    private SourceCallbackModel sourceCallbackModel;
    @Mock
    private ParameterModel invalidParameterModel;
    @Mock
    private OutputModel outputModel;
    private ExportedTypesModelValidator validator = new ExportedTypesModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Arrays.asList(this.sourceModel));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"dummyOperation");
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(Void.TYPE));
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"dummySource");
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel, this.sourceModel});
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToOperationWithArgumentParameterWithoutGetter() {
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class));
        Mockito.when((Object)this.invalidParameterModel.getName()).thenReturn((Object)"pojo");
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.invalidParameterModel));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToOperationWithReturnTypeParameterWithoutGetter() {
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToSourceWithReturnTypeParameterWithoutGetter() {
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void outputAttributesAreNotValidated() {
        OutputModel outputAttributes = (OutputModel)Mockito.mock(OutputModel.class);
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.sourceModel.getOutputAttributes()).thenReturn((Object)outputAttributes);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithGetter.class));
        Mockito.when((Object)outputAttributes.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    private static class PojoWithParameterWithGetter {
        @Parameter
        private String fieldWithGetter;

        private PojoWithParameterWithGetter() {
        }

        public String getFieldWithGetter() {
            return this.fieldWithGetter;
        }
    }

    private static class PojoWithParameterWithoutGetter {
        @Parameter
        private String fieldWithoutGetter;

        private PojoWithParameterWithoutGetter() {
        }
    }
}

