/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.internal.loader.validator.OperationParametersModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationParameterModelValidatorTestCase
extends AbstractMuleTestCase {
    public static final String EXTENSION_NAME = "extension";
    public static final String OPERATION_NAME = "operation";
    @Mock
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationModel operationModel;
    @Mock
    private ParameterModel goodParameter;
    private ExtensionModelValidator validator = new OperationParametersModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.operationModel.getOutputAttributes().getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(NullAttributes.class));
        Mockito.when((Object)this.goodParameter.getName()).thenReturn((Object)"valid");
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.goodParameter));
    }

    private void validate() {
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test
    public void valid() {
        this.validate();
    }

    @Test
    public void validForParameterLessOperation() {
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn((Object)ImmutableList.of());
        this.validate();
    }
}

