/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;

public final class JavaExportedTypesDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        Export exportAnnotation = this.extractAnnotation((BaseDeclaration<? extends BaseDeclaration>)extensionLoadingContext.getExtensionDeclarer().getDeclaration(), Export.class);
        if (exportAnnotation != null) {
            ExtensionDeclarer declarer = extensionLoadingContext.getExtensionDeclarer();
            Arrays.stream(exportAnnotation.classes()).map(arg_0 -> ((ClassTypeLoader)this.typeLoader).load(arg_0)).forEach(type -> this.registerType(declarer, (MetadataType)type));
            Arrays.stream(exportAnnotation.resources()).forEach(arg_0 -> ((ExtensionDeclarer)declarer).withResource(arg_0));
        }
    }

    private void registerType(final ExtensionDeclarer declarer, MetadataType type) {
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    ((MetadataType)objectType.getOpenRestriction().get()).accept((MetadataTypeVisitor)this);
                } else {
                    declarer.withType(objectType);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitIntersection(IntersectionType intersectionType) {
                intersectionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept((MetadataTypeVisitor)this);
            }
        });
    }
}

