/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.Stereotype;
import org.mule.runtime.api.meta.model.operation.RouteModel;
import org.mule.runtime.api.meta.model.operation.RouterModel;
import org.mule.runtime.api.meta.model.operation.ScopeModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.tck.TestCoreExtensionDeclarer;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.AbstractJavaExtensionDeclarationTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class CoreExtensionDeclarationTestCase
extends AbstractJavaExtensionDeclarationTestCase {
    private ExtensionModel extensionModel;

    @Before
    public void before() {
        this.extensionModel = new ExtensionModelLoader(){

            public String getId() {
                return "test";
            }

            protected void declareExtension(ExtensionLoadingContext context) {
                new TestCoreExtensionDeclarer().declareOn(context.getExtensionDeclarer());
            }
        }.loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()), new HashMap());
    }

    @Test
    public void assertDeclaration() {
        Assert.assertThat((Object)this.extensionModel.getName(), (Matcher)CoreMatchers.is((Object)"core"));
        Assert.assertThat((Object)this.extensionModel.getDescription(), (Matcher)CoreMatchers.is((Object)"Core Extension"));
        Assert.assertThat((Object)this.extensionModel.getVersion(), (Matcher)CoreMatchers.is((Object)"1.0"));
        Assert.assertThat((Object)this.extensionModel.getConfigurationModels(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.extensionModel.getVendor(), (Matcher)CoreMatchers.is((Object)"Mulesoft"));
        Assert.assertThat((Object)this.extensionModel.getOperationModels(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.extensionModel.getConnectionProviders(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.extensionModel.getSourceModels(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void choiceRouter() {
        RouterModel choice = (RouterModel)this.extensionModel.getOperationModel("choice").get();
        Assert.assertThat((Object)choice.getAllParameterModels(), (Matcher)Matchers.hasSize((int)0));
        List routes = choice.getRouteModels();
        Assert.assertThat((Object)routes, (Matcher)Matchers.hasSize((int)2));
        this.assertRoute((RouteModel)routes.get(0), "when", 1, null, new Stereotype[0]);
        this.assertRoute((RouteModel)routes.get(1), "otherwise", 0, 1, new Stereotype[0]);
    }

    @Test
    public void foreachScope() {
        ScopeModel foreach = (ScopeModel)this.extensionModel.getOperationModel("foreach").get();
        Assert.assertThat((Object)foreach.getAllParameterModels(), (Matcher)Matchers.hasSize((int)1));
        ParameterModel parameter = (ParameterModel)foreach.getAllParameterModels().get(0);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"expression"));
        ExtensionsTestUtils.assertType(parameter.getType(), String.class, StringType.class);
    }

    private void assertRoute(RouteModel route, String name, int minOccurs, Integer maxOccurs, Stereotype ... stereotypes) {
        Assert.assertThat((Object)route.getName(), (Matcher)CoreMatchers.is((Object)name));
        Assert.assertThat((Object)route.getMinOccurs(), (Matcher)CoreMatchers.is((Object)minOccurs));
        if (maxOccurs != null) {
            Assert.assertThat(route.getMaxOccurs().get(), (Matcher)CoreMatchers.is((Object)maxOccurs));
        } else {
            Assert.assertThat((Object)route.getMaxOccurs().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        }
        if (Arrays.isNullOrEmpty((Object[])stereotypes)) {
            Assert.assertThat((Object)route.getAllowedStereotypes().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        } else {
            Assert.assertThat(route.getAllowedStereotypes().get(), (Matcher)Matchers.containsInAnyOrder((Object[])stereotypes));
        }
    }
}

