/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;

class EnricherTestUtils {
    private EnricherTestUtils() {
    }

    public static <T extends NamedDeclaration> T getDeclaration(List<T> operationList, String name) {
        return (T)((NamedDeclaration)operationList.stream().filter(operation -> operation.getName().equals(name)).collect(Collectors.toList()).get(0));
    }

    public static <T extends NamedObject> T getNamedObject(List<T> operationList, String name) {
        return (T)((NamedObject)operationList.stream().filter(operation -> operation.getName().equals(name)).collect(Collectors.toList()).get(0));
    }

    public static <T extends ModelProperty> T checkIsPresent(BaseDeclaration declaration, Class<T> modelProperty) {
        Optional property = declaration.getModelProperty(modelProperty);
        Assert.assertThat((Object)property.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (T)((ModelProperty)property.get());
    }
}

