/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.Methylamine;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionTypesDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private ExtensionModel extensionModel;

    @Before
    public void before() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    }

    @Test
    public void assertTypes() throws Exception {
        this.assertTypes(this.extensionModel.getTypes(), true, "Type %s was not present", Ricin.class, KnockeableDoor.class, HeisenbergException.class, CarWash.class, Weapon.class, Weapon.WeaponAttributes.class, PersonalInfo.class, Methylamine.class);
        this.assertTypes(this.extensionModel.getTypes(), false, "Invalid type %s was exported", Object.class, Map.class);
    }

    private void assertTypes(Set<ObjectType> extensionTypes, boolean typeShouldBePresent, String message, Class<?> ... expectedTypes) {
        for (Class<?> expectedType : expectedTypes) {
            Optional<ObjectType> extensionType = extensionTypes.stream().filter(type -> ExtensionMetadataTypeUtils.getId((MetadataType)type).equals(expectedType.getCanonicalName())).findFirst();
            Assert.assertThat((String)String.format(message, expectedType.getName()), (Object)extensionType.isPresent(), (Matcher)CoreMatchers.is((Object)typeShouldBePresent));
        }
    }
}

