/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.property.ClassLoaderModelProperty;
import org.mule.runtime.module.extension.internal.loader.validation.NullSafeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class NullSafeModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ParameterModel parameterModel;
    private ExtensionModelValidator validator = new NullSafeModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.parameterModel);
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.empty());
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void collectionWithImplementingType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(CollectionWithDefaultImplementingType.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void dictionaryWithImplementingType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(DictionaryWithDefaultImplementingType.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void implementingTypeIsNotAssignable() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(ImplementingTypeNotAssignable.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void basicTypeField() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(BasicTypeWithNullSafe.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void abstractFieldType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(AbstractNullSafeTypeWithoutOverride.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void abstractImplementingType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(AbstractNullSafeTypeWithAbstractOverride.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test
    public void validModel() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(ValidModel.class));
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    private static abstract class AbstractChildPojo
    extends ParentPojo {
        private AbstractChildPojo() {
        }
    }

    private static class ChildPojo
    extends ParentPojo {
    }

    private static class UnrelatedPojo {
        private UnrelatedPojo() {
        }
    }

    private static abstract class ParentPojo {
        private ParentPojo() {
        }
    }

    private static class ValidModel {
        @Parameter
        @NullSafe(defaultImplementingType=ChildPojo.class)
        @org.mule.runtime.extension.api.annotation.param.Optional
        private ParentPojo pojo;
        @Parameter
        @NullSafe
        @org.mule.runtime.extension.api.annotation.param.Optional
        private ChildPojo childPojo;
        @Parameter
        @NullSafe
        @org.mule.runtime.extension.api.annotation.param.Optional
        private Map<String, String> mapOfStrings;
        @Parameter
        @NullSafe
        @org.mule.runtime.extension.api.annotation.param.Optional
        private List<String> listOfStrings;

        private ValidModel() {
        }
    }

    private static class AbstractNullSafeTypeWithAbstractOverride {
        @Parameter
        @NullSafe(defaultImplementingType=AbstractChildPojo.class)
        @org.mule.runtime.extension.api.annotation.param.Optional
        private ParentPojo pojo;

        private AbstractNullSafeTypeWithAbstractOverride() {
        }
    }

    private static class AbstractNullSafeTypeWithoutOverride {
        @Parameter
        @NullSafe
        @org.mule.runtime.extension.api.annotation.param.Optional
        private ParentPojo pojo;

        private AbstractNullSafeTypeWithoutOverride() {
        }
    }

    private static class ImplementingTypeNotAssignable {
        @Parameter
        @NullSafe(defaultImplementingType=UnrelatedPojo.class)
        @org.mule.runtime.extension.api.annotation.param.Optional
        private ParentPojo pojo;

        private ImplementingTypeNotAssignable() {
        }
    }

    private static class BasicTypeWithNullSafe {
        @Parameter
        @NullSafe
        @org.mule.runtime.extension.api.annotation.param.Optional
        private String bla;

        private BasicTypeWithNullSafe() {
        }
    }

    private static class DictionaryWithDefaultImplementingType {
        @Parameter
        @NullSafe(defaultImplementingType=LinkedList.class)
        @org.mule.runtime.extension.api.annotation.param.Optional
        private Map<String, String> strings;

        private DictionaryWithDefaultImplementingType() {
        }
    }

    private static class CollectionWithDefaultImplementingType {
        @Parameter
        @NullSafe(defaultImplementingType=LinkedList.class)
        @org.mule.runtime.extension.api.annotation.param.Optional
        private List<String> strings;

        private CollectionWithDefaultImplementingType() {
        }
    }
}

