/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.module.extension.internal.loader.validation.OperationReturnTypeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationReturnTypeModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    private OperationReturnTypeModelValidator validator = new OperationReturnTypeModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Message.Payload", ExtensionsTestUtils.toMetadataType(String.class), false, Collections.emptySet()));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"operation");
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
    }

    @Test
    public void valid() {
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void muleEventReturnType() {
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Message.Payload", ExtensionsTestUtils.toMetadataType(Event.class), false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void muleMessageReturnType() {
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Message.Payload", ExtensionsTestUtils.toMetadataType(Message.class), false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

