/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterTypeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ParameterTypeModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ParameterModel parameter;
    private Type objectKey = new TypeToken<Map<Object, Object>>(){}.getType();
    private Type stringMap = new TypeToken<Map<String, Object>>(){}.getType();
    private Type wildcardMap = new TypeToken<Map<?, ?>>(){}.getType();
    private Type rawMap = new TypeToken<Map>(){}.getType();
    private ParameterTypeModelValidator validator = new ParameterTypeModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.parameter.getName()).thenReturn((Object)"mapParameter");
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.parameter);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void objectKey() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(this.objectKey));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void stringKey() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(this.stringMap));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void wildcardMap() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(this.wildcardMap));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void rawMap() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(this.rawMap));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void boxedBoolean() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(Boolean.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void primitiveBoolean() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(Boolean.TYPE));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

