/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.manifest;

import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.resources.AbstractGeneratedResourceFactoryTestCase;
import org.mule.runtime.module.extension.internal.resources.manifest.ExtensionManifestGenerator;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class ExtensionManifestGeneratorTestCase
extends AbstractGeneratedResourceFactoryTestCase {
    private ExtensionManifestGenerator generator = new ExtensionManifestGenerator();
    private ExtensionModel extensionModel;

    @Before
    public void before() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    }

    @Override
    protected Class<? extends GeneratedResourceFactory>[] getResourceFactoryTypes() {
        return new Class[]{ExtensionManifestGenerator.class};
    }

    @Test
    public void generate() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/heisenberg-test-manifest.xml");
        Assert.assertThat((Object)in, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String expectedSchema = IOUtils.toString((InputStream)in);
        Optional resource = this.generator.generateResource(this.extensionModel);
        Assert.assertThat((Object)resource.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ExtensionsTestUtils.compareXML(expectedSchema, new String(((GeneratedResource)resource.get()).getContent()));
    }
}

