/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.core.retry.policies.SimpleRetryPolicyTemplate;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.Interceptable;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultExecutionMediatorTestCase
extends AbstractMuleContextTestCase {
    public static final int RETRY_COUNT = 10;
    private static final String DUMMY_NAME = "dummyName";
    private static final String ERROR = "Error";
    private final Object result = new Object();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExecutionContextAdapter operationContext;
    @Mock(extraInterfaces={Interceptable.class})
    private ConfigurationInstance configurationInstance;
    @Mock
    private MutableConfigurationStats configurationStats;
    @Mock(extraInterfaces={Interceptable.class})
    private OperationExecutor operationExecutor;
    @Mock
    private OperationExecutor operationExceptionExecutor;
    @Mock
    private Interceptor configurationInterceptor1;
    @Mock
    private Interceptor configurationInterceptor2;
    @Mock
    private Interceptor operationInterceptor1;
    @Mock
    private Interceptor operationInterceptor2;
    @Mock
    private ExceptionHandler exceptionEnricher;
    @Mock
    private ConfigurationModel configurationModel;
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ConnectionManagerAdapter connectionManagerAdapter;
    private ConnectionException connectionException = new ConnectionException("Connection failure");
    private Exception exception = new Exception();
    private InOrder inOrder;
    private List<Interceptor> orderedInterceptors;
    private ExecutionMediator mediator;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.configurationInstance.getStatistics()).thenReturn((Object)this.configurationStats);
        Mockito.when((Object)this.configurationInstance.getName()).thenReturn((Object)DUMMY_NAME);
        Mockito.when((Object)this.configurationInstance.getModel()).thenReturn((Object)this.configurationModel);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)DUMMY_NAME);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, null);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, null);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)this.operationContext)).thenReturn((Object)Mono.just((Object)this.result));
        Mockito.when((Object)this.operationExceptionExecutor.execute((ExecutionContext)this.operationContext)).thenReturn((Object)Mono.error((Throwable)this.exception));
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        Mockito.when((Object)this.operationContext.getExtensionModel().getName()).thenReturn((Object)DUMMY_NAME);
        Mockito.when((Object)this.operationContext.getTransactionConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        this.mediator = new DefaultExecutionMediator(this.extensionModel, this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), muleContext.getErrorTypeRepository());
        ReconnectableConnectionProviderWrapper connectionProviderWrapper = new ReconnectableConnectionProviderWrapper(null, false, (RetryPolicyTemplate)new SimpleRetryPolicyTemplate(10L, 10));
        LifecycleUtils.initialiseIfNeeded((Object)connectionProviderWrapper, (boolean)true, (MuleContext)muleContext);
        Optional<ReconnectableConnectionProviderWrapper> connectionProvider = Optional.of(connectionProviderWrapper);
        Mockito.when((Object)this.configurationInstance.getConnectionProvider()).thenReturn(connectionProvider);
        Mockito.when((Object)this.exceptionEnricher.enrichException(this.exception)).thenReturn((Object)new HeisenbergException(ERROR));
        this.setInterceptors((Interceptable)this.configurationInstance, this.configurationInterceptor1, this.configurationInterceptor2);
        this.setInterceptors((Interceptable)this.operationExecutor, this.operationInterceptor1, this.operationInterceptor2);
        this.defineOrder(this.configurationInterceptor1, this.configurationInterceptor2, this.operationInterceptor1, this.operationInterceptor2);
    }

    @Test
    public void interceptorsInvokedOnSuccess() throws Throwable {
        Object result = this.execute().block();
        this.assertBefore();
        this.assertOnSuccess(Mockito.times((int)1));
        this.assertOnError(Mockito.never());
        this.assertAfter(result);
        this.assertResult(result);
    }

    @Test
    public void interceptorsInvokedOnError() throws Throwable {
        this.stubException();
        this.assertException(e -> {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
            try {
                this.assertBefore();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            this.assertOnSuccess(Mockito.never());
            this.assertOnError(Mockito.times((int)1));
            this.assertAfter(null);
        });
    }

    @Test
    public void decoratedException() throws Throwable {
        this.stubException();
        Exception decoratedException = (Exception)Mockito.mock(Exception.class);
        Mockito.when((Object)this.configurationInterceptor2.onError((ExecutionContext)Matchers.same((Object)this.operationContext), (Throwable)Matchers.same((Object)this.connectionException))).thenReturn((Object)decoratedException);
        this.assertException(e -> {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)decoratedException)));
            this.assertAfter(null);
        });
    }

    @Test
    public void exceptionOnBefore() throws Throwable {
        this.stubExceptionOnBeforeInterceptor();
        this.assertException(e -> {
            try {
                Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
                this.assertBefore();
                this.assertOnError(Mockito.never());
                ((OperationExecutor)Mockito.verify((Object)this.operationExecutor, (VerificationMode)Mockito.never())).execute((ExecutionContext)this.operationContext);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        });
    }

    @Test
    public void configurationStatsOnSuccessfulOperation() throws Throwable {
        this.execute().block();
        this.assertStatistics();
    }

    @Test
    public void configurationStatsOnFailedOperation() throws Throwable {
        this.stubException();
        this.assertException(e -> this.assertStatistics());
    }

    @Test
    public void configurationStatsOnFailedBeforeInterceptor() throws Throwable {
        this.stubExceptionOnBeforeInterceptor();
        this.assertException(e -> this.assertStatistics());
    }

    @Test
    public void enrichThrownException() throws Throwable {
        this.expectedException.expectCause(CoreMatchers.instanceOf(HeisenbergException.class));
        this.expectedException.expectMessage(ERROR);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any())).thenReturn((Object)Mono.error((Throwable)new Exception()));
        Mono.from((Publisher)new DefaultExecutionMediator(this.extensionModel, this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), muleContext.getErrorTypeRepository()).execute(this.operationExceptionExecutor, this.operationContext)).block();
    }

    @Test
    public void retry() throws Throwable {
        this.stubException();
        Interceptor interceptor = (Interceptor)Mockito.mock(Interceptor.class);
        this.setInterceptors((Interceptable)this.configurationInstance, interceptor);
        this.setInterceptors((Interceptable)this.operationExecutor, new Interceptor[0]);
        this.defineOrder(interceptor);
        this.assertException(exception -> {
            Assert.assertThat((Object)exception, (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
            try {
                ((Interceptor)Mockito.verify((Object)interceptor, (VerificationMode)Mockito.times((int)11))).before((ExecutionContext)this.operationContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ((Interceptor)Mockito.verify((Object)interceptor, (VerificationMode)Mockito.times((int)11))).onError((ExecutionContext)Matchers.same((Object)this.operationContext), (Throwable)Matchers.anyVararg());
            ((Interceptor)Mockito.verify((Object)interceptor, (VerificationMode)Mockito.times((int)11))).after((ExecutionContext)this.operationContext, null);
        });
    }

    private void assertException(Consumer<Throwable> assertion) throws Throwable {
        try {
            this.execute().block();
            Assert.fail((String)"was expecting a exception");
        }
        catch (Exception e) {
            assertion.accept(Exceptions.unwrap((Throwable)e));
        }
    }

    private void stubExceptionOnBeforeInterceptor() throws Exception {
        ((Interceptor)Mockito.doThrow((Throwable)this.exception).when((Object)this.operationInterceptor2)).before((ExecutionContext)this.operationContext);
    }

    private void assertStatistics() {
        ((MutableConfigurationStats)Mockito.verify((Object)this.configurationStats)).addInflightOperation();
        ((MutableConfigurationStats)Mockito.verify((Object)this.configurationStats)).discountInflightOperation();
    }

    private void assertBefore() throws Exception {
        this.verifyInOrder(interceptor -> {
            try {
                interceptor.before((ExecutionContext)this.operationContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void assertOnSuccess(VerificationMode verificationMode) {
        this.verifyInOrder(interceptor -> interceptor.onSuccess((ExecutionContext)this.operationContext, this.result), verificationMode);
    }

    private void assertOnError(VerificationMode verificationMode) {
        this.verifyInOrder(interceptor -> interceptor.onError((ExecutionContext)Matchers.same((Object)this.operationContext), (Throwable)Matchers.same((Object)this.connectionException)), verificationMode);
    }

    private void assertAfter(Object expected) {
        this.verifyInOrder(interceptor -> interceptor.after((ExecutionContext)this.operationContext, expected));
    }

    private void assertResult(Object result) {
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.result)));
    }

    private void stubException() throws Exception {
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)this.operationContext)).thenReturn((Object)Mono.error((Throwable)this.connectionException));
    }

    private void setInterceptors(Interceptable interceptable, Interceptor ... interceptors) {
        Mockito.when((Object)interceptable.getInterceptors()).thenReturn(Arrays.asList(interceptors));
    }

    private void defineOrder(Interceptor ... interceptors) {
        this.inOrder = Mockito.inOrder((Object[])interceptors);
        this.orderedInterceptors = ImmutableList.copyOf((Object[])interceptors);
    }

    private void verifyInOrder(Consumer<Interceptor> consumer) {
        this.verifyInOrder(consumer, Mockito.times((int)1));
    }

    private void verifyInOrder(Consumer<Interceptor> consumer, VerificationMode verificationMode) {
        for (Interceptor interceptor : this.orderedInterceptors) {
            consumer.accept((Interceptor)this.inOrder.verify((Object)interceptor, verificationMode));
        }
    }

    private Mono<Object> execute() throws MuleException {
        return Mono.from((Publisher)this.mediator.execute(this.operationExecutor, this.operationContext));
    }
}

