/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.NestedProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.module.extension.internal.runtime.resolver.NestedProcessorValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class NestedProcessorValueResolverTestCase
extends AbstractMuleContextTestCase {
    @Mock
    private Processor messageProcessor;

    @Before
    public void before() throws Exception {
        Event testEvent = this.testEvent();
        Mockito.when((Object)this.messageProcessor.process((Event)Matchers.any(Event.class))).thenReturn((Object)testEvent);
    }

    @Test
    public void yieldsNestedProcessor() throws Exception {
        NestedProcessorValueResolver resolver = new NestedProcessorValueResolver(this.messageProcessor);
        resolver.setMuleContext(muleContext);
        NestedProcessor nestedProcessor = resolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        Object response = nestedProcessor.process();
        Assert.assertThat((Object)((String)response), (Matcher)CoreMatchers.is((Object)"test"));
        ArgumentCaptor captor = ArgumentCaptor.forClass(Event.class);
        ((Processor)Mockito.verify((Object)this.messageProcessor)).process((Event)captor.capture());
        Event capturedEvent = (Event)captor.getValue();
        Assert.assertThat((Object)capturedEvent, (Matcher)CoreMatchers.is((Object)this.testEvent()));
    }

    @Test
    public void alwaysGivesDifferentInstances() throws Exception {
        NestedProcessorValueResolver resolver = new NestedProcessorValueResolver(this.messageProcessor);
        resolver.setMuleContext(muleContext);
        NestedProcessor resolved1 = resolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        NestedProcessor resolved2 = resolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        Assert.assertThat((Object)resolved1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)resolved2))));
    }
}

