/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class TypeSafeExpressionValueResolverTestCase
extends AbstractMuleContextTestCase {
    private static final String HELLO_WORLD = "Hello World!";
    private static final MetadataType STRING = new JavaTypeLoader(Thread.currentThread().getContextClassLoader()).load(String.class);
    private ExtendedExpressionManager expressionManager;

    protected void doSetUp() throws Exception {
        muleContext = (MuleContext)Mockito.spy((Object)muleContext);
        this.expressionManager = (ExtendedExpressionManager)Mockito.spy((Object)muleContext.getExpressionManager());
        Mockito.when((Object)muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
    }

    @Test
    public void expressionLanguageWithoutTransformation() throws Exception {
        this.assertResolved(this.getResolver("#[mel:'Hello ' + payload]", STRING).resolve(ValueResolvingContext.from((Event)TypeSafeExpressionValueResolverTestCase.eventBuilder().message(Message.of((Object)"World!")).build())), HELLO_WORLD, Mockito.never());
    }

    @Test
    public void expressionTemplateWithoutTransformation() throws Exception {
        this.assertResolved(this.getResolver("Hello #[mel:payload]", STRING).resolve(ValueResolvingContext.from((Event)TypeSafeExpressionValueResolverTestCase.eventBuilder().message(Message.of((Object)"World!")).build())), HELLO_WORLD, Mockito.times((int)1));
    }

    @Test
    public void constant() throws Exception {
        this.assertResolved(this.getResolver(HELLO_WORLD, STRING).resolve(ValueResolvingContext.from((Event)TypeSafeExpressionValueResolverTestCase.eventBuilder().message(Message.of((Object)HELLO_WORLD)).build())), HELLO_WORLD, Mockito.never());
    }

    @Test
    public void expressionWithTransformation() throws Exception {
        this.assertResolved(this.getResolver("#[mel:true]", STRING).resolve(ValueResolvingContext.from((Event)TypeSafeExpressionValueResolverTestCase.eventBuilder().message(Message.of((Object)HELLO_WORLD)).build())), "true", Mockito.never());
    }

    @Test
    public void templateWithTransformation() throws Exception {
        this.assertResolved(this.getResolver("tru#[mel:'e']", STRING).resolve(ValueResolvingContext.from((Event)TypeSafeExpressionValueResolverTestCase.eventBuilder().message(Message.of((Object)HELLO_WORLD)).build())), "true", Mockito.times((int)1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullExpression() throws Exception {
        this.getResolver(null, STRING);
    }

    @Test(expected=IllegalArgumentException.class)
    public void blankExpression() throws Exception {
        this.getResolver("", STRING);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullExpectedType() throws Exception {
        this.getResolver("#[mel:payload]", null);
    }

    private void assertResolved(Object resolvedValue, Object expected, VerificationMode expressionManagerVerificationMode) {
        Assert.assertThat((Object)resolvedValue, (Matcher)IsInstanceOf.instanceOf(String.class));
        Assert.assertThat((Object)resolvedValue, (Matcher)CoreMatchers.equalTo((Object)expected));
        this.verifyExpressionManager(expressionManagerVerificationMode);
    }

    private void verifyExpressionManager(VerificationMode mode) {
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManager, (VerificationMode)mode)).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class));
    }

    private <T> ValueResolver<T> getResolver(String expression, MetadataType expectedType) throws Exception {
        TypeSafeExpressionValueResolver valueResolver = new TypeSafeExpressionValueResolver(expression, expectedType);
        valueResolver.setExtendedExpressionManager(this.expressionManager);
        valueResolver.setTransformationService(muleContext.getTransformationService());
        valueResolver.initialise();
        return valueResolver;
    }
}

