/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TypeSafeValueResolverWrapperTestCase
extends AbstractMuleContextTestCase {
    private TransformationService transformationService = (TransformationService)Mockito.mock(TransformationService.class);
    private ValueResolver<String> staticValueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
    private ValueResolver<String> dynamicValueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
    private TypeSafeValueResolverWrapper<Integer> dynamicResolver;
    private TypeSafeValueResolverWrapper<Integer> staticResolver;

    protected void doSetUp() throws Exception {
        muleContext = (MuleContext)Mockito.spy((Object)muleContext);
        ExtendedExpressionManager expressionManager = (ExtendedExpressionManager)Mockito.spy((Object)muleContext.getExpressionManager());
        Mockito.when((Object)this.staticValueResolver.isDynamic()).thenReturn((Object)false);
        Mockito.when((Object)this.staticValueResolver.resolve((ValueResolvingContext)Matchers.any(ValueResolvingContext.class))).thenReturn((Object)"123");
        Mockito.when((Object)this.dynamicValueResolver.isDynamic()).thenReturn((Object)true);
        Mockito.when((Object)this.dynamicValueResolver.resolve((ValueResolvingContext)Matchers.any(ValueResolvingContext.class))).thenReturn((Object)"123");
        Mockito.when((Object)muleContext.getExpressionManager()).thenReturn((Object)expressionManager);
        this.dynamicResolver = new TypeSafeValueResolverWrapper(this.dynamicValueResolver, Integer.class);
        this.dynamicResolver.setTransformationService(this.transformationService);
        this.dynamicResolver.initialise();
        this.staticResolver = new TypeSafeValueResolverWrapper(this.staticValueResolver, Integer.class);
        this.staticResolver.setTransformationService(this.transformationService);
        this.staticResolver.initialise();
        Mockito.when((Object)this.transformationService.transform(Matchers.eq((Object)"123"), (DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class))).thenReturn((Object)123);
    }

    @Test
    public void staticValueIsTransformed() throws MuleException {
        Integer resolve = (Integer)this.staticResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        MatcherAssert.assertThat((Object)resolve, (Matcher)CoreMatchers.is((Object)123));
    }

    @Test
    public void staticValueIsTransformedOnlyOnce() throws MuleException {
        this.staticResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        this.staticResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        this.staticResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        this.staticResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        this.staticResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        ((ValueResolver)Mockito.verify(this.staticValueResolver, (VerificationMode)Mockito.times((int)1))).resolve((ValueResolvingContext)Matchers.any(ValueResolvingContext.class));
    }

    @Test
    public void dynamicValueIsTransformed() throws MuleException {
        Integer resolve = (Integer)this.dynamicResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        MatcherAssert.assertThat((Object)resolve, (Matcher)CoreMatchers.is((Object)123));
    }

    @Test
    public void dynamicValueIsTransformedOnlyOnce() throws MuleException {
        this.dynamicResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        this.dynamicResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        this.dynamicResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        this.dynamicResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        this.dynamicResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        ((ValueResolver)Mockito.verify(this.dynamicValueResolver, (VerificationMode)Mockito.times((int)5))).resolve((ValueResolvingContext)Matchers.any(ValueResolvingContext.class));
    }

    @Test
    public void transformNullValue() throws MuleException {
        Mockito.when((Object)this.staticValueResolver.resolve((ValueResolvingContext)Matchers.any(ValueResolvingContext.class))).thenReturn(null);
        Integer value = (Integer)this.staticResolver.resolve(ValueResolvingContext.from((Event)this.testEvent()));
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

