/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import javax.transaction.xa.XAResource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.runtime.core.transaction.XaTransaction;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.runtime.module.extension.internal.runtime.transaction.XAExtensionTransactionalResource;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class XAExtensionTransactionalResourceTestCase
extends AbstractMuleTestCase {
    @Mock
    private XaTransaction transaction;
    @Mock
    private XATransactionalConnection connection;
    @Mock
    private ConnectionHandler connectionHandler;
    @Mock
    private XAResource xaResource;
    private XAExtensionTransactionalResource resource;

    @Before
    public void before() throws Exception {
        this.resource = new XAExtensionTransactionalResource(this.connection, this.connectionHandler, (Transaction)this.transaction);
        Mockito.when((Object)this.connection.getXAResource()).thenReturn((Object)this.xaResource);
        Mockito.when((Object)this.transaction.enlistResource(this.xaResource)).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.delistResource(this.xaResource, 0x4000000)).thenReturn((Object)true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.transaction);
    }

    @After
    public void cleanUp() throws Exception {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    @Test
    public void enlist() throws Exception {
        Assert.assertThat((Object)this.resource.enlist(), (Matcher)CoreMatchers.is((Object)true));
        ((XaTransaction)Mockito.verify((Object)this.transaction)).enlistResource(this.xaResource);
    }

    @Test
    public void idempotentEnlist() throws Exception {
        this.enlist();
        ((XaTransaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.times((int)1))).enlistResource(this.xaResource);
    }

    @Test
    public void delist() throws Exception {
        this.enlist();
        Assert.assertThat((Object)this.resource.delist(), (Matcher)CoreMatchers.is((Object)true));
        ((XaTransaction)Mockito.verify((Object)this.transaction)).delistResource(this.xaResource, 0x4000000);
    }

    @Test
    public void delistWithoutEnlist() throws Exception {
        Assert.assertThat((Object)this.resource.delist(), (Matcher)CoreMatchers.is((Object)false));
        ((XaTransaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.never())).delistResource((XAResource)Matchers.same((Object)this.xaResource), Matchers.anyInt());
    }

    @Test
    public void close() throws Exception {
        this.resource.close();
        ((XATransactionalConnection)Mockito.verify((Object)this.connection)).close();
    }

    @Test
    public void getTargetObject() {
        Assert.assertThat((Object)this.resource.getTargetObject(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.connection)));
    }
}

