/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclarer;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Route;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class RouterModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String CONSTRUCT = "Construct";
    private final Map<MethodElement, ConstructDeclarer> constructDeclarers = new HashMap<MethodElement, ConstructDeclarer>();

    RouterModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareRouter(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer ownerDeclarer, Class<?> declaringClass, MethodElement routerMethod, Method method, Optional<ExtensionParameter> configParameter, Optional<ExtensionParameter> connectionParameter) {
        OperationModelLoaderDelegate.checkDefinition(!configParameter.isPresent(), String.format("Scope '%s' requires a config, but that is not allowed, remove such parameter", method.getName()));
        OperationModelLoaderDelegate.checkDefinition(!connectionParameter.isPresent(), String.format("Scope '%s' requires a connection, but that is not allowed, remove such parameter", method.getName()));
        HasConstructDeclarer actualDeclarer = (HasConstructDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)ownerDeclarer, configParameter, connectionParameter);
        if (this.constructDeclarers.containsKey(routerMethod)) {
            actualDeclarer.withConstruct(this.constructDeclarers.get(routerMethod));
            return;
        }
        ConstructDeclarer router = (ConstructDeclarer)((ConstructDeclarer)actualDeclarer.withConstruct(routerMethod.getAlias()).withModelProperty((ModelProperty)new ImplementingMethodModelProperty(method))).withModelProperty((ModelProperty)new ComponentExecutorModelProperty(new ReflectiveOperationExecutorFactory(declaringClass, method)));
        this.processMimeType((HasModelProperties)router, routerMethod);
        List callbackParameters = routerMethod.getParameters().stream().filter(p -> RouterCompletionCallback.class.equals((Object)p.getType().getDeclaringClass())).collect(Collectors.toList());
        List<ExtensionParameter> routes = routerMethod.getParameters().stream().filter(this::isRoute).collect(Collectors.toList());
        OperationModelLoaderDelegate.checkDefinition(!callbackParameters.isEmpty(), String.format("Router '%s' does not declare a '%s' parameter. One is required.", routerMethod.getAlias(), RouterCompletionCallback.class.getSimpleName()));
        OperationModelLoaderDelegate.checkDefinition(!routes.isEmpty(), String.format("Router '%s' does not declare a '%s' parameter. One is required.", routerMethod.getAlias(), Route.class.getSimpleName()));
        OperationModelLoaderDelegate.checkDefinition(callbackParameters.size() <= 1, String.format("Router '%s' defines more than one %s parameters. Only one is allowed", routerMethod.getAlias(), RouterCompletionCallback.class.getSimpleName()));
        OperationModelLoaderDelegate.checkDefinition(IntrospectionUtils.isVoid(routerMethod.getMethod()), String.format("Router '%s' is not declared in a void method.", routerMethod.getAlias()));
        this.loader.getMethodParametersLoader().declare((HasParametersDeclarer)router, routerMethod.getParameters().stream().filter(p -> !this.isRoute((ExtensionParameter)p) && !callbackParameters.contains(p)).collect(Collectors.toList()), new ParameterDeclarationContext(CONSTRUCT, (NamedDeclaration)router.getDeclaration()));
        this.declareRoutes(router, routes);
    }

    private void declareRoutes(ConstructDeclarer router, List<ExtensionParameter> routes) {
        routes.forEach(route -> {
            NestedRouteDeclarer routeDeclarer = router.withRoute(route.getAlias()).describedAs(route.getDescription()).withMinOccurs(route.isRequired() ? 1 : 0);
            routeDeclarer.withModelProperty((ModelProperty)new ImplementingTypeModelProperty(route.getType().getDeclaringClass()));
            List<FieldElement> parameters = route.getType().getAnnotatedFields(Parameter.class);
            this.loader.getFieldParametersLoader().declare((HasParametersDeclarer)routeDeclarer, parameters, new ParameterDeclarationContext(CONSTRUCT, (NamedDeclaration)router.getDeclaration()));
        });
    }

    private boolean isRoute(ExtensionParameter parameter) {
        return Route.class.isAssignableFrom(parameter.getType().getDeclaringClass());
    }
}

