/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes;

import java.util.Optional;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class StackableType {
    private final Class type;
    private final ExpressionBasedResolverFactory expressionBasedResolverFactory;
    private final StaticResolverFactory staticResolverFactory;
    private final DelegateResolverFactory delegateResolverFactory;

    private StackableType(Class type, ExpressionBasedResolverFactory expressionBasedResolverFactory, StaticResolverFactory staticResolverFactory, DelegateResolverFactory delegateResolverFactory) {
        this.type = type;
        this.expressionBasedResolverFactory = expressionBasedResolverFactory;
        this.staticResolverFactory = staticResolverFactory;
        this.delegateResolverFactory = delegateResolverFactory;
    }

    public Class getType() {
        return this.type;
    }

    Optional<ExpressionBasedResolverFactory> getExpressionBasedResolverFactory() {
        return Optional.ofNullable(this.expressionBasedResolverFactory);
    }

    Optional<StaticResolverFactory> getStaticResolverFactory() {
        return Optional.ofNullable(this.staticResolverFactory);
    }

    Optional<DelegateResolverFactory> getDelegateResolverFactory() {
        return Optional.ofNullable(this.delegateResolverFactory);
    }

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder(type);
    }

    @FunctionalInterface
    public static interface DelegateResolverFactory<T> {
        public ValueResolver<T> getResolver(ValueResolver var1);
    }

    @FunctionalInterface
    public static interface StaticResolverFactory<T> {
        public ValueResolver<T> getResolver(Object var1);
    }

    @FunctionalInterface
    public static interface ExpressionBasedResolverFactory<T> {
        public ValueResolver<T> getResolver(String var1, Class<T> var2);
    }

    public static class Builder<T> {
        private Class<T> type;
        private ExpressionBasedResolverFactory<T> expressionBasedResolverFactory;
        private StaticResolverFactory staticResolverFactory;
        private DelegateResolverFactory delegateResolverFactory;

        private Builder(Class<T> type) {
            this.type = type;
        }

        public Builder<T> setExpressionBasedResolverFactory(ExpressionBasedResolverFactory<T> expressionBasedResolverFactory) {
            this.expressionBasedResolverFactory = expressionBasedResolverFactory;
            return this;
        }

        public Builder<T> setStaticResolverFactory(StaticResolverFactory<T> staticResolverFactory) {
            this.staticResolverFactory = staticResolverFactory;
            return this;
        }

        public Builder<T> setDelegateResolverFactory(DelegateResolverFactory<T> delegateResolverFactory) {
            this.delegateResolverFactory = delegateResolverFactory;
            return this;
        }

        public StackableType build() {
            return new StackableType(this.type, this.expressionBasedResolverFactory, this.staticResolverFactory, this.delegateResolverFactory);
        }
    }
}

