/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes;

import java.util.Optional;
import java.util.Stack;
import java.util.function.Supplier;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackableType;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class StackableTypesValueResolverFactory {
    private Supplier<Stack<StackableType>> types;

    StackableTypesValueResolverFactory(Stack<StackableType> stackableTypes) {
        Preconditions.checkArgument((!stackableTypes.empty() ? 1 : 0) != 0, (String)"Stackable Types cannot be empty");
        this.types = () -> {
            Stack stack = new Stack();
            stack.addAll(stackableTypes);
            return stack;
        };
    }

    public ValueResolver getExpressionBasedValueResolver(String expression, Class expectedType) {
        Stack<StackableType> stackableTypes = this.types.get();
        StackableType stackableType = stackableTypes.pop();
        StackableType.ExpressionBasedResolverFactory resolverFactory = stackableType.getExpressionBasedResolverFactory().orElseThrow(() -> new IllegalStateException(String.format("Unable to create an Expression Based ValueResolver of '%s' type. No ExpressionBasedResolverFactory was registered for this type.", stackableType.getType().getSimpleName())));
        ValueResolver resolver = resolverFactory.getResolver(expression, expectedType);
        resolver = this.getWrapperValueResolver(resolver, stackableTypes);
        return resolver;
    }

    public ValueResolver getStaticValueResolver(Object value) {
        Stack<StackableType> stackableTypes = this.types.get();
        StackableType stackableType = stackableTypes.pop();
        StackableType.StaticResolverFactory resolverFactory = stackableType.getStaticResolverFactory().orElseThrow(() -> new IllegalStateException(String.format("Unable to create an Static ValueResolver of '%s' type. No StaticResolverFactory was registered for this type.", stackableType.getType().getSimpleName())));
        ValueResolver resolver = resolverFactory.getResolver(value);
        resolver = this.getWrapperValueResolver(resolver, stackableTypes);
        return resolver;
    }

    public Optional<ValueResolver> getStaticValueResolver(Object value, Class clazz) {
        Stack<StackableType> stackableTypes = this.types.get();
        StackableType stackableType = (StackableType)stackableTypes.get(stackableTypes.size() - 1);
        if (stackableType.getType().equals(clazz)) {
            return Optional.of(this.getStaticValueResolver(value));
        }
        return Optional.empty();
    }

    public ValueResolver getWrapperValueResolver(ValueResolver resolverDelegate) {
        return this.getWrapperValueResolver(resolverDelegate, this.types.get());
    }

    private ValueResolver getWrapperValueResolver(ValueResolver resolver, Stack<StackableType> types) {
        while (!types.empty()) {
            StackableType delegateStackableType = types.pop();
            StackableType.DelegateResolverFactory delegateResolverFactory = delegateStackableType.getDelegateResolverFactory().orElseThrow(() -> new IllegalStateException(String.format("Unable to create a ValueResolver Wrapper of '%s' type. No DelegateResolverFactory was registered for this type.", delegateStackableType.getType().getSimpleName())));
            resolver = delegateResolverFactory.getResolver(resolver);
        }
        return resolver;
    }
}

