/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.function;

import com.google.common.base.Defaults;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionExecutor;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionExecutorFactory;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionParameterDefaultValueResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.function.ReflectiveExpressionFunctionExecutor;

public final class ReflectiveFunctionExecutorFactory<T>
implements FunctionExecutorFactory {
    private final Class<T> implementationClass;
    private final Method method;

    public ReflectiveFunctionExecutorFactory(Class<T> implementationClass, Method method) {
        Preconditions.checkArgument((implementationClass != null ? 1 : 0) != 0, (String)"implementationClass cannot be null");
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (String)"operationMethod cannot be null");
        this.implementationClass = implementationClass;
        this.method = method;
    }

    @Override
    public FunctionExecutor createExecutor(FunctionModel functionModel, FunctionParameterDefaultValueResolverFactory defaultResolverFactory) {
        DataType returnType = DataType.fromType((Class)((Class)ExtensionMetadataTypeUtils.getType((MetadataType)functionModel.getOutput().getType()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to obtain the return type for function [%s]", functionModel.getName()))))));
        List<FunctionParameter> functionParameters = functionModel.getAllParameterModels().stream().map(p -> {
            DataType type = DataType.fromType((Class)((Class)ExtensionMetadataTypeUtils.getType((MetadataType)p.getType()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to obtain the type for parameter [%s] in function [%s]", p.getName(), functionModel.getName()))))));
            if (p.isRequired()) {
                return new FunctionParameter(p.getName(), type);
            }
            Object defaultValue = p.getDefaultValue();
            if (defaultValue == null) {
                return new FunctionParameter(p.getName(), type, context -> Defaults.defaultValue((Class)type.getType()));
            }
            return new FunctionParameter(p.getName(), type, defaultResolverFactory.create(defaultValue, type));
        }).collect(Collectors.toList());
        return new ReflectiveExpressionFunctionExecutor(functionModel, returnType, functionParameters, this.method, this.getDelegateInstance());
    }

    private Object getDelegateInstance() {
        T delegate;
        try {
            delegate = this.implementationClass.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create instance of operation class " + this.implementationClass.getName())), (Throwable)e);
        }
        return delegate;
    }
}

