/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigOverrideValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectTypeParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class NullSafeValueResolverWrapper<T>
implements ValueResolver<T>,
Initialisable {
    private final ValueResolver<T> delegate;
    private final ValueResolver<T> fallback;
    private final MuleContext muleContext;

    public static <T> ValueResolver<T> of(ValueResolver<T> delegate, MetadataType type, final MuleContext muleContext, final ObjectTypeParametersResolver parametersResolver) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (String)"delegate cannot be null");
        final Reference value = new Reference();
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                Class clazz = JavaTypeUtils.getType((MetadataType)objectType);
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    value.set(MapValueResolver.of(clazz, Collections.emptyList(), Collections.emptyList(), muleContext));
                    return;
                }
                String requiredFields = objectType.getFields().stream().filter(f -> f.isRequired() && !ExtensionMetadataTypeUtils.isFlattenedParameterGroup((MetadataType)f)).map(MetadataTypeUtils::getLocalPart).collect(Collectors.joining(", "));
                if (!StringUtils.isBlank((CharSequence)requiredFields)) {
                    throw new IllegalParameterModelDefinitionException(String.format("Class '%s' cannot be used with '@%s' parameter since it contains non optional fields: [%s]", clazz.getName(), NullSafe.class.getSimpleName(), requiredFields));
                }
                ResolverSet resolverSet = new ResolverSet(muleContext);
                for (Field field : IntrospectionUtils.getFields(clazz)) {
                    ValueResolver<Object> resolver = null;
                    ObjectFieldType objectField = objectType.getFieldByName(IntrospectionUtils.getAlias(field)).orElse(null);
                    if (objectField == null) continue;
                    Optional defaultValue = MetadataTypeUtils.getDefaultValue((MetadataType)objectField);
                    if (defaultValue.isPresent()) {
                        resolver = ResolverUtils.getFieldDefaultValueValueResolver(objectField, muleContext);
                    } else if (ExtensionMetadataTypeUtils.isFlattenedParameterGroup((MetadataType)objectField)) {
                        DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(JavaTypeUtils.getType((MetadataType)objectField.getValue()));
                        resolverSet.add(field.getName(), new ObjectBuilderValueResolver(groupBuilder, muleContext));
                        ObjectType childGroup = (ObjectType)objectField.getValue();
                        parametersResolver.resolveParameters(childGroup, groupBuilder);
                        parametersResolver.resolveParameterGroups(childGroup, groupBuilder);
                    } else {
                        NullSafe nullSafe = field.getAnnotation(NullSafe.class);
                        if (nullSafe != null) {
                            Object nullSafeType = Object.class.equals((Object)nullSafe.defaultImplementingType()) ? objectField.getValue() : new BaseTypeBuilder(MetadataFormat.JAVA).objectType().with((TypeAnnotation)new TypeIdAnnotation(nullSafe.defaultImplementingType().getName())).build();
                            resolver = NullSafeValueResolverWrapper.of(new StaticValueResolver<Object>(null), nullSafeType, muleContext, parametersResolver);
                        }
                        if (field.getAnnotation(ConfigOverride.class) != null) {
                            resolver = ConfigOverrideValueResolverWrapper.of(resolver != null ? resolver : new StaticValueResolver<Object>(null), field.getName(), muleContext);
                        }
                    }
                    if (resolver == null) continue;
                    resolverSet.add(field.getName(), resolver);
                }
                DefaultResolverSetBasedObjectBuilder objectBuilder = new DefaultResolverSetBasedObjectBuilder(clazz, resolverSet);
                value.set(new ObjectBuilderValueResolver(objectBuilder, muleContext));
            }

            public void visitArrayType(ArrayType arrayType) {
                Class collectionClass = JavaTypeUtils.getType((MetadataType)arrayType);
                value.set(CollectionValueResolver.of(collectionClass, Collections.emptyList()));
            }

            protected void defaultVisit(MetadataType metadataType) {
                throw new IllegalParameterModelDefinitionException(String.format("Cannot use @%s on type '%s'", NullSafe.class.getSimpleName(), JavaTypeUtils.getType((MetadataType)metadataType)));
            }
        });
        return new NullSafeValueResolverWrapper<T>(delegate, (ValueResolver)value.get(), muleContext);
    }

    private NullSafeValueResolverWrapper(ValueResolver<T> delegate, ValueResolver<T> fallback, MuleContext muleContext) {
        this.delegate = delegate;
        this.fallback = fallback;
        this.muleContext = muleContext;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        T value = this.delegate.resolve(context);
        return value == null ? this.fallback.resolve(context) : value;
    }

    @Override
    public boolean isDynamic() {
        return this.delegate.isDynamic() || this.fallback.isDynamic();
    }

    public void initialise() throws InitialisationException {
        try {
            this.muleContext.getInjector().inject(this.delegate);
            this.muleContext.getInjector().inject(this.fallback);
            LifecycleUtils.initialiseIfNeeded(this.delegate, (MuleContext)this.muleContext);
            LifecycleUtils.initialiseIfNeeded(this.fallback, (MuleContext)this.muleContext);
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }
}

