/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class CraftedExtensionModelLoader
extends ExtensionModelLoader {
    public static final String CRAFTED_LOADER_ID = "crafted";
    public static final String TYPE_PROPERTY_NAME = "type";

    public String getId() {
        return CRAFTED_LOADER_ID;
    }

    protected void declareExtension(ExtensionLoadingContext context) {
        ExtensionLoadingDelegate delegate;
        Class<?> delegateType = this.getDelegateType(context, context.getExtensionClassLoader());
        if (!ExtensionLoadingDelegate.class.isAssignableFrom(delegateType)) {
            throw new IllegalArgumentException(String.format("Property '%s' was expected to point to an implementation of the '%s', but '%s' was found instead", TYPE_PROPERTY_NAME, ExtensionLoadingDelegate.class.getName(), delegateType.getClass().getName()));
        }
        if (!IntrospectionUtils.isInstantiable(delegateType)) {
            throw new IllegalArgumentException(String.format("Type '%s' is not instantiable. A concrete class with a public default constructor was expected", delegateType.getName()));
        }
        try {
            delegate = (ExtensionLoadingDelegate)ClassUtils.instantiateClass(delegateType, (Object[])new Object[0]);
        }
        catch (Throwable e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not instantiate type '%s'", delegateType.getName())), e);
        }
        delegate.accept(context.getExtensionDeclarer(), context);
    }

    private Class<?> getDelegateType(ExtensionLoadingContext context, ClassLoader classLoader) {
        String type = (String)context.getParameter(TYPE_PROPERTY_NAME).orElseThrow(() -> new IllegalArgumentException(String.format("Property '%s' has not been specified", TYPE_PROPERTY_NAME)));
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException(String.format("'%s' property cannot be blank", TYPE_PROPERTY_NAME));
        }
        try {
            return ClassUtils.loadClass((String)type, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Class '%s' cannot be loaded", type), e);
        }
    }
}

