/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.time.TimeSupplier;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;

public final class ImmutableExpirationPolicy
extends AbstractAnnotatedObject
implements ExpirationPolicy {
    private final long maxIdleTime;
    private final TimeUnit timeUnit;
    private final TimeSupplier timeSupplier;

    public static ExpirationPolicy getDefault(TimeSupplier timeSupplier) {
        return new ImmutableExpirationPolicy(5L, TimeUnit.MINUTES, timeSupplier);
    }

    public ImmutableExpirationPolicy(long maxIdleTime, TimeUnit timeUnit, TimeSupplier timeSupplier) {
        this.maxIdleTime = maxIdleTime;
        this.timeUnit = timeUnit;
        this.timeSupplier = timeSupplier;
    }

    public boolean isExpired(long lastUsed, TimeUnit timeUnit) {
        long idleTimeMillis = this.timeSupplier.get() - timeUnit.toMillis(lastUsed);
        return idleTimeMillis > this.timeUnit.toMillis(this.maxIdleTime);
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

