/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.Interceptable;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionHandlerManager;
import org.mule.runtime.module.extension.internal.runtime.exception.ModuleExceptionHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.InterceptorsExecutionResult;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class DefaultExecutionMediator
implements ExecutionMediator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionMediator.class);
    private final ExceptionHandlerManager exceptionEnricherManager;
    private final ConnectionManagerAdapter connectionManager;
    private final ExecutionTemplate<?> defaultExecutionTemplate = callback -> callback.process();
    private final ModuleExceptionHandler moduleExceptionHandler;

    public DefaultExecutionMediator(ExtensionModel extensionModel, OperationModel operationModel, ConnectionManagerAdapter connectionManager, ErrorTypeRepository typeRepository) {
        this.connectionManager = connectionManager;
        this.exceptionEnricherManager = new ExceptionHandlerManager(extensionModel, (ComponentModel)operationModel);
        this.moduleExceptionHandler = new ModuleExceptionHandler((ComponentModel)operationModel, extensionModel, typeRepository);
    }

    @Override
    public Publisher<Object> execute(OperationExecutor executor, ExecutionContextAdapter context) {
        Optional<MutableConfigurationStats> stats = this.getMutableConfigurationStats(context);
        stats.ifPresent(s -> s.addInflightOperation());
        try {
            return (Mono)this.getExecutionTemplate(context).execute(() -> this.executeWithInterceptors(executor, context, this.collectInterceptors(context, executor), stats));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)Exceptions.wrapFatal((Throwable)t));
        }
    }

    private Mono<Object> executeWithInterceptors(OperationExecutor executor, ExecutionContextAdapter context, List<Interceptor> interceptors, Optional<MutableConfigurationStats> stats) {
        ArrayList executedInterceptors = new ArrayList(interceptors.size());
        Mono publisher = Mono.create(sink -> {
            Mono result;
            InterceptorsExecutionResult beforeExecutionResult = this.before(context, interceptors);
            if (beforeExecutionResult.isOk()) {
                result = Mono.from((Publisher)executor.execute((ExecutionContext)context));
                executedInterceptors.addAll(interceptors);
            } else {
                result = Mono.error((Throwable)beforeExecutionResult.getThrowable());
                executedInterceptors.addAll(beforeExecutionResult.getExecutedInterceptors());
            }
            result.doOnSuccess(value -> {
                this.onSuccess(context, value, interceptors);
                stats.ifPresent(s -> s.discountInflightOperation());
                sink.success(value);
            }).onErrorMap(e -> {
                e = this.exceptionEnricherManager.process((Throwable)e);
                e = this.moduleExceptionHandler.processException((Throwable)e);
                e = this.onError(context, (Throwable)e, interceptors);
                return e;
            }).subscribe(value -> {}, arg_0 -> ((MonoSink)sink).error(arg_0));
        }).doOnTerminate((value, e) -> {
            try {
                this.after(context, value, executedInterceptors);
            }
            finally {
                executedInterceptors.clear();
            }
        });
        return Mono.from((Publisher)this.getRetryPolicyTemplate(context.getConfiguration()).applyPolicy((Publisher)publisher, e -> ExceptionUtils.extractConnectionException((Throwable)e).isPresent(), e -> stats.ifPresent(s -> s.discountInflightOperation())));
    }

    InterceptorsExecutionResult before(ExecutionContext executionContext, List<Interceptor> interceptors) {
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>();
        try {
            for (Interceptor interceptor : interceptors) {
                interceptorList.add(interceptor);
                interceptor.before(executionContext);
            }
        }
        catch (Exception e) {
            return new InterceptorsExecutionResult(this.exceptionEnricherManager.handleThrowable(e), interceptorList);
        }
        return new InterceptorsExecutionResult(null, interceptorList);
    }

    private void onSuccess(ExecutionContext executionContext, Object result, List<Interceptor> interceptors) {
        this.intercept(interceptors, interceptor -> interceptor.onSuccess(executionContext, result), interceptor -> String.format("Interceptor %s threw exception executing 'onSuccess' phase. Exception will be ignored. Next interceptors (if any) will be executed and the operation's result will be returned", interceptor));
    }

    private Throwable onError(ExecutionContext executionContext, Throwable e, List<Interceptor> interceptors) {
        Reference exceptionHolder = new Reference((Object)e);
        this.intercept(interceptors, interceptor -> {
            Throwable decoratedException = interceptor.onError(executionContext, (Throwable)exceptionHolder.get());
            if (decoratedException != null) {
                exceptionHolder.set((Object)decoratedException);
            }
        }, interceptor -> String.format("Interceptor %s threw exception executing 'onError' phase. Exception will be ignored. Next interceptors (if any) will be executed and the operation's exception will be returned", interceptor));
        return (Throwable)exceptionHolder.get();
    }

    void after(ExecutionContext executionContext, Object result, List<Interceptor> interceptors) {
        this.intercept(interceptors, interceptor -> interceptor.after(executionContext, result), interceptor -> String.format("Interceptor %s threw exception executing 'after' phase. Exception will be ignored. Next interceptors (if any) will be executed and the operation's result be returned", interceptor));
    }

    private void intercept(List<Interceptor> interceptors, Consumer<Interceptor> closure, Function<Interceptor, String> exceptionMessageFunction) {
        interceptors.forEach(interceptor -> {
            block2: {
                try {
                    closure.accept((Interceptor)interceptor);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block2;
                    LOGGER.debug((String)exceptionMessageFunction.apply((Interceptor)interceptor), (Throwable)e);
                }
            }
        });
    }

    private <T> ExecutionTemplate<T> getExecutionTemplate(ExecutionContextAdapter<OperationModel> context) {
        return context.getTransactionConfig().map(txConfig -> TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)context.getMuleContext(), (TransactionConfig)txConfig)).orElse(this.defaultExecutionTemplate);
    }

    private RetryPolicyTemplate getRetryPolicyTemplate(Optional<ConfigurationInstance> configurationInstance) {
        ConnectionProvider connectionProvider;
        Optional connectionProviderOptional = configurationInstance.map(ConfigurationInstance::getConnectionProvider).orElse(Optional.empty());
        if (connectionProviderOptional.isPresent() && ConnectionProviderWrapper.class.isAssignableFrom((connectionProvider = (ConnectionProvider)connectionProviderOptional.get()).getClass())) {
            return ((ConnectionProviderWrapper)connectionProvider).getRetryPolicyTemplate();
        }
        return this.connectionManager.getDefaultRetryPolicyTemplate();
    }

    private Optional<MutableConfigurationStats> getMutableConfigurationStats(ExecutionContext<ComponentModel> context) {
        return context.getConfiguration().map(ConfigurationInstance::getStatistics).filter(s -> s instanceof MutableConfigurationStats).map(s -> (MutableConfigurationStats)s);
    }

    private List<Interceptor> collectInterceptors(ExecutionContextAdapter context, OperationExecutor executor) {
        return this.collectInterceptors(context.getConfiguration(), context instanceof PrecalculatedExecutionContextAdapter ? ((PrecalculatedExecutionContextAdapter)context).getOperationExecutor() : executor);
    }

    List<Interceptor> collectInterceptors(Optional<ConfigurationInstance> configurationInstance, OperationExecutor executor) {
        LinkedList<Interceptor> accumulator = new LinkedList<Interceptor>();
        configurationInstance.ifPresent(config -> this.collectInterceptors(accumulator, config));
        this.collectInterceptors(accumulator, (Object)executor);
        return accumulator;
    }

    private void collectInterceptors(List<Interceptor> accumulator, Object subject) {
        if (subject instanceof Interceptable) {
            accumulator.addAll(((Interceptable)subject).getInterceptors());
        }
    }
}

