/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.execution.MessageProcessContext;
import org.mule.runtime.core.api.execution.MessageProcessTemplate;
import org.mule.runtime.core.api.execution.MessageProcessingManager;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.ModuleFlowProcessingTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionSourceBinder;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

class DefaultSourceCallback<T, A>
implements SourceCallback<T, A> {
    private static final String UNABLE_TO_START_TX_ERROR_MSG_TEMPLATE = "Unable to start a transaction from the Source '%s' of the extension '%s' without a %s";
    private SourceModel sourceModel;
    private Processor listener;
    private MuleContext muleContext;
    private ExtensionMessageSource messageSource;
    private FlowConstruct flowConstruct;
    private ExceptionCallback exceptionCallback;
    private MessageProcessingManager messageProcessingManager;
    private Supplier<MessageProcessContext> processContextSupplier;
    private SourceCompletionHandlerFactory completionHandlerFactory;
    private CursorProviderFactory cursorProviderFactory;
    private boolean returnsListOfMessages = false;
    private TransactionSourceBinder transactionSourceBinder;

    static Builder builder() {
        return new Builder();
    }

    private DefaultSourceCallback() {
    }

    public void handle(Result<T, A> result) {
        this.handle(result, this.createContext());
    }

    public void handle(Result<T, A> result, SourceCallbackContext context) {
        MessageProcessContext messageProcessContext = this.processContextSupplier.get();
        SourceResultAdapter resultAdapter = new SourceResultAdapter(result, this.cursorProviderFactory, this.returnsListOfMessages);
        Message message = Message.of((Object)resultAdapter);
        Optional transactionConfig = messageProcessContext.getTransactionConfig();
        if (transactionConfig.isPresent()) {
            this.executeFlowTransactionally(context, messageProcessContext, message, (TransactionConfig)transactionConfig.get());
        } else {
            this.executeFlow(context, messageProcessContext, message);
        }
    }

    private void executeFlowTransactionally(SourceCallbackContext context, MessageProcessContext messageProcessContext, Message message, TransactionConfig transactionConfig) {
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)this.muleContext, (TransactionConfig)transactionConfig);
        ConnectionHandler connectionHandler = this.messageSource.getConnectionHandler().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format(UNABLE_TO_START_TX_ERROR_MSG_TEMPLATE, this.sourceModel.getName(), this.messageSource.getExtensionModel().getName(), "connection"))));
        ConfigurationInstance configurationInstance = this.messageSource.getConfigurationInstance().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format(UNABLE_TO_START_TX_ERROR_MSG_TEMPLATE, this.sourceModel.getName(), this.messageSource.getExtensionModel().getName(), "configuration"))));
        try {
            executionTemplate.execute(() -> {
                this.transactionSourceBinder.bindToTransaction(transactionConfig, configurationInstance, connectionHandler);
                this.executeFlow(context, messageProcessContext, message);
                return null;
            });
        }
        catch (Exception e) {
            this.onSourceException(e);
        }
    }

    private void executeFlow(SourceCallbackContext context, MessageProcessContext messageProcessContext, Message message) {
        this.messageProcessingManager.processMessage((MessageProcessTemplate)new ModuleFlowProcessingTemplate(message, this.listener, this.completionHandlerFactory.createCompletionHandler(context)), messageProcessContext);
    }

    public void onSourceException(Throwable exception) {
        this.exceptionCallback.onException(exception);
    }

    public SourceCallbackContext createContext() {
        return new DefaultSourceCallbackContext(this);
    }

    static class Builder<T, A> {
        private DefaultSourceCallback<T, A> product = new DefaultSourceCallback();

        private Builder() {
        }

        public Builder<T, A> setSourceModel(SourceModel sourceModel) {
            ((DefaultSourceCallback)this.product).sourceModel = sourceModel;
            ((DefaultSourceCallback)this.product).returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages((ComponentModel)sourceModel);
            return this;
        }

        public Builder<T, A> setListener(Processor listener) {
            ((DefaultSourceCallback)this.product).listener = listener;
            return this;
        }

        public Builder<T, A> setMuleContext(MuleContext muleContext) {
            ((DefaultSourceCallback)this.product).muleContext = muleContext;
            return this;
        }

        public Builder<T, A> setSource(ExtensionMessageSource messageSource) {
            ((DefaultSourceCallback)this.product).messageSource = messageSource;
            return this;
        }

        public Builder<T, A> setFlowConstruct(FlowConstruct flowConstruct) {
            ((DefaultSourceCallback)this.product).flowConstruct = flowConstruct;
            return this;
        }

        public Builder<T, A> setExceptionCallback(ExceptionCallback exceptionCallback) {
            ((DefaultSourceCallback)this.product).exceptionCallback = exceptionCallback;
            return this;
        }

        public Builder<T, A> setProcessingManager(MessageProcessingManager processingManager) {
            ((DefaultSourceCallback)this.product).messageProcessingManager = processingManager;
            return this;
        }

        public Builder<T, A> setProcessContextSupplier(Supplier<MessageProcessContext> processContextSupplier) {
            ((DefaultSourceCallback)this.product).processContextSupplier = processContextSupplier;
            return this;
        }

        public Builder<T, A> setCompletionHandlerFactory(SourceCompletionHandlerFactory completionHandlerFactory) {
            ((DefaultSourceCallback)this.product).completionHandlerFactory = completionHandlerFactory;
            return this;
        }

        public Builder<T, A> setCursorStreamProviderFactory(CursorProviderFactory cursorProviderFactory) {
            ((DefaultSourceCallback)this.product).cursorProviderFactory = cursorProviderFactory;
            return this;
        }

        public SourceCallback<T, A> build() {
            this.checkArgument(((DefaultSourceCallback)this.product).listener, "listener");
            this.checkArgument(((DefaultSourceCallback)this.product).flowConstruct, "flowConstruct");
            this.checkArgument(((DefaultSourceCallback)this.product).exceptionCallback, "exceptionCallback");
            this.checkArgument(((DefaultSourceCallback)this.product).messageProcessingManager, "messageProcessingManager");
            this.checkArgument(((DefaultSourceCallback)this.product).processContextSupplier, "processContextSupplier");
            this.checkArgument(((DefaultSourceCallback)this.product).completionHandlerFactory, "completionHandlerSupplier");
            this.checkArgument(((DefaultSourceCallback)this.product).sourceModel, "sourceModel");
            this.checkArgument(((DefaultSourceCallback)this.product).cursorProviderFactory, "cursorStreamProviderFactory");
            this.checkArgument((Object)((DefaultSourceCallback)this.product).messageSource, "messageSource");
            this.checkArgument(((DefaultSourceCallback)this.product).muleContext, "muleContext");
            ((DefaultSourceCallback)this.product).transactionSourceBinder = new TransactionSourceBinder(((DefaultSourceCallback)this.product).messageSource.getExtensionModel(), (ComponentModel)((DefaultSourceCallback)this.product).sourceModel);
            return this.product;
        }

        private void checkArgument(Object value, String name) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)(name + " was not set"));
        }
    }
}

