/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Objects;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ElementReference;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.springframework.util.ClassUtils;

public final class ParameterTypeModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                ParameterTypeModelValidator.this.validateParameterType(model, problemsReporter);
                ParameterTypeModelValidator.this.validateParameterWithReferencesType(model, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateParameterWithReferencesType(ParameterModel parameter, ProblemsReporter problemsReporter) {
        if (!parameter.getElementReferences().isEmpty() && !(parameter.getType() instanceof StringType)) {
            problemsReporter.addError(new Problem((NamedObject)parameter, String.format("Parameter '%s' that a contains reference to a [%s] should be of type String but is of type %s", parameter.getName(), ((ElementReference)parameter.getElementReferences().get(0)).getType(), parameter.getType())));
        }
    }

    private void validateParameterType(final ParameterModel parameter, final ProblemsReporter problemsReporter) {
        parameter.getType().accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    objectType.getAnnotation(ClassInformationAnnotation.class).filter(classInformation -> !classInformation.getGenericTypes().isEmpty()).filter(classInformation -> !Objects.equals(classInformation.getGenericTypes().get(0), String.class.getName())).ifPresent(classInformation -> problemsReporter.addError(new Problem((NamedObject)parameter, String.format("Parameter '%s' is of type '%s' and its key type is not %s ", parameter.getName(), JavaTypeUtils.getType((MetadataType)objectType).getName(), String.class.getName()))));
                }
            }

            public void visitBoolean(BooleanType booleanType) {
                if (ClassUtils.isPrimitiveWrapper((Class)JavaTypeUtils.getType((MetadataType)booleanType))) {
                    problemsReporter.addError(new Problem((NamedObject)parameter, String.format("Parameter '%s' is of type '%s'. Use primitive type boolean instead.", parameter.getName(), Boolean.class.getName())));
                }
            }
        });
    }
}

