/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;

public final class ConnectionInterceptor
implements Interceptor {
    private static final String CLOSE_CONNECTION_COMMAND = "closeCommand";
    @Inject
    private ExtensionConnectionSupplier connectionSupplier;

    public void before(ExecutionContext<OperationModel> executionContext) throws Exception {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        Preconditions.checkArgument((context.getVariable("MULE_CONNECTION_PARAM") == null ? 1 : 0) != 0, (String)"A connection was already set for this operation context");
        context.setVariable("MULE_CONNECTION_PARAM", this.getConnection(context));
        this.setCloseCommand(executionContext, () -> this.release(executionContext));
    }

    public Throwable onError(ExecutionContext<OperationModel> executionContext, Throwable exception) {
        ExceptionUtils.extractConnectionException((Throwable)exception).ifPresent(e -> this.setCloseCommand(executionContext, () -> this.onConnection(executionContext, ConnectionHandler::invalidate)));
        return exception;
    }

    public void after(ExecutionContext<OperationModel> executionContext, Object result) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        Runnable closeCommand = (Runnable)context.removeVariable(CLOSE_CONNECTION_COMMAND);
        closeCommand.run();
    }

    private void release(ExecutionContext<OperationModel> executionContext) {
        this.onConnection(executionContext, ConnectionHandler::release);
    }

    private void onConnection(ExecutionContext<OperationModel> executionContext, Consumer<ConnectionHandler> consumer) {
        ConnectionHandler handler = (ConnectionHandler)((ExecutionContextAdapter)executionContext).removeVariable("MULE_CONNECTION_PARAM");
        if (handler != null) {
            consumer.accept(handler);
        }
    }

    private void setCloseCommand(ExecutionContext<OperationModel> executionContext, Runnable command) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        context.setVariable(CLOSE_CONNECTION_COMMAND, command);
    }

    private ConnectionHandler<?> getConnection(ExecutionContextAdapter<? extends ComponentModel> operationContext) throws ConnectionException, TransactionException {
        return this.connectionSupplier.getConnection(operationContext);
    }
}

