/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.value.ValueProviderMediatorUtils;

public final class ValueProviderMediator<T extends ParameterizedModel & EnrichableModel> {
    private T containerModel;
    private MuleContext muleContext;
    private Supplier<Object> NULL_SUPPLIER = () -> null;

    public ValueProviderMediator(T containerModel, MuleContext muleContext) {
        this.containerModel = containerModel;
        this.muleContext = muleContext;
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, this.NULL_SUPPLIER, this.NULL_SUPPLIER);
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) throws org.mule.runtime.extension.api.values.ValueResolvingException {
        List<ParameterModel> parameters = this.getParameters(parameterName);
        if (parameters.isEmpty()) {
            throw new org.mule.runtime.extension.api.values.ValueResolvingException(String.format("Unable to find model for parameter or parameter group with name '%s'.", parameterName), "INVALID_VALUE_RESOLVER_NAME");
        }
        ParameterModel parameterModel = parameters.get(0);
        ValueProviderFactoryModelProperty factoryModelProperty = (ValueProviderFactoryModelProperty)parameterModel.getModelProperty(ValueProviderFactoryModelProperty.class).orElseThrow(() -> new org.mule.runtime.extension.api.values.ValueResolvingException(String.format("The parameter with name '%s' is not an Values Provider", parameterName), "INVALID_VALUE_RESOLVER_NAME"));
        try {
            return this.resolveValues(parameters, factoryModelProperty, parameterValueResolver, connectionSupplier, configurationSupplier);
        }
        catch (Exception e) {
            throw new org.mule.runtime.extension.api.values.ValueResolvingException(String.format("An error occurred trying to resolve the Values for parameter '%s' of component '%s'", parameterName, this.containerModel.getName()), "UNKNOWN", (Throwable)e);
        }
    }

    private Set<Value> resolveValues(List<ParameterModel> parameters, ValueProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, InitialisationException, ValueResolvingException, org.mule.runtime.extension.api.values.ValueResolvingException {
        ValueProvider valueProvider = factoryModelProperty.createFactory(parameterValueResolver, connectionSupplier, configurationSupplier, this.muleContext).createValueProvider();
        Set valueSet = valueProvider.resolve();
        return valueSet.stream().map(option -> ValueProviderMediatorUtils.cloneAndEnrichValue(option, parameters)).map(ValueBuilder::build).collect(Collectors.toSet());
    }

    private List<ParameterModel> getParameters(String valueName) {
        return this.containerModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getValueProviderModel().map(provider -> provider.getProviderName().equals(valueName)).orElse(false)).collect(Collectors.toList());
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

