/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.module.extension.internal.AbstractInterceptableContractTestCase;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.TestTimeSupplier;

@SmallTest
@RunWith(value=Parameterized.class)
public class LifecycleAwareConfigurationInstanceTestCase
extends AbstractInterceptableContractTestCase<LifecycleAwareConfigurationInstance> {
    protected static final int RECONNECTION_MAX_ATTEMPTS = 5;
    private static final int RECONNECTION_FREQ = 100;
    private static final String NAME = "name";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private ConfigurationModel configurationModel;
    @Mock
    private ConfigurationState configurationState;
    protected Lifecycle value = (Lifecycle)Mockito.mock(Lifecycle.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{AnnotatedObject.class}));
    @Mock
    protected ConnectionManagerAdapter connectionManager;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private String name;
    protected Optional<ConnectionProvider> connectionProvider;
    private TestTimeSupplier timeSupplier = new TestTimeSupplier(System.currentTimeMillis());

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"With provider", Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class, MuleContextAware.class}))}, {"Without provider", null});
    }

    public LifecycleAwareConfigurationInstanceTestCase(String name, ConnectionProvider connectionProvider) {
        this.name = name;
        this.connectionProvider = Optional.ofNullable(connectionProvider);
    }

    @Override
    @Before
    public void before() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        muleContext.getRegistry().registerObject("_muleConnectionManager", (Object)this.connectionManager);
        muleContext.getRegistry().registerObject("_muleTimeSupplier", (Object)this.timeSupplier);
        this.retryPolicyTemplate = this.createRetryTemplate();
        this.retryPolicyTemplate.setNotifier((RetryNotifier)Mockito.mock(RetryNotifier.class));
        super.before();
    }

    protected RetryPolicyTemplate createRetryTemplate() {
        return new SimpleRetryPolicyTemplate(100L, 5);
    }

    @After
    public void after() {
        ((LifecycleAwareConfigurationInstance)this.interceptable).dispose();
    }

    @Override
    protected LifecycleAwareConfigurationInstance createInterceptable() {
        if (this.connectionProvider.isPresent()) {
            this.reset(this.connectionProvider.get());
        }
        this.setup(this.connectionManager);
        return new LifecycleAwareConfigurationInstance(NAME, this.configurationModel, (Object)this.value, this.configurationState, this.getInterceptors(), this.connectionProvider);
    }

    private void setup(ConnectionManagerAdapter connectionManager) {
        if (this.connectionProvider.isPresent()) {
            Mockito.when((Object)connectionManager.getRetryTemplateFor(this.connectionProvider.get())).thenReturn((Object)this.retryPolicyTemplate);
            Mockito.when((Object)connectionManager.testConnectivity((ConfigurationInstance)Mockito.any(ConfigurationInstance.class))).thenReturn((Object)ConnectionValidationResult.success());
        }
    }

    private void reset(Object object) {
        Mockito.reset((Object[])new Object[]{object});
        if (object instanceof ConnectionManagerAdapter) {
            this.setup((ConnectionManagerAdapter)object);
        }
    }

    @Test
    public void valueInjected() throws Exception {
        ((LifecycleAwareConfigurationInstance)this.interceptable).initialise();
        ((Injector)Mockito.verify((Object)this.injector)).inject((Object)this.value);
        if (this.connectionProvider.isPresent()) {
            ((Injector)Mockito.verify((Object)this.injector)).inject((Object)this.connectionProvider.get());
        } else {
            ((Injector)Mockito.verify((Object)this.injector, (VerificationMode)Mockito.never())).inject((Object)CoreMatchers.any(ConnectionProvider.class));
        }
    }

    @Test
    public void connectionBound() throws Exception {
        ((LifecycleAwareConfigurationInstance)this.interceptable).initialise();
        this.assertBound();
    }

    private void assertBound() throws Exception {
        if (this.connectionProvider.isPresent()) {
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.times((int)1))).bind((Object)this.value, this.connectionProvider.get());
        } else {
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.never())).bind(Matchers.same((Object)this.value), (ConnectionProvider)Matchers.anyObject());
        }
    }

    private VerificationMode getBindingVerificationMode() {
        return this.connectionProvider.map(p -> Mockito.times((int)1)).orElse(Mockito.never());
    }

    @Test
    public void connectionReBoundfterStopStart() throws Exception {
        this.connectionBound();
        ((LifecycleAwareConfigurationInstance)this.interceptable).start();
        ((LifecycleAwareConfigurationInstance)this.interceptable).stop();
        ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)this.getBindingVerificationMode())).unbind((Object)this.value);
        this.reset(this.connectionManager);
        ((LifecycleAwareConfigurationInstance)this.interceptable).start();
        this.assertBound();
    }

    @Test
    public void valueInitialised() throws Exception {
        ((LifecycleAwareConfigurationInstance)this.interceptable).initialise();
        ((Initialisable)Mockito.verify((Object)this.value)).initialise();
        if (this.connectionProvider.isPresent()) {
            ((Initialisable)Mockito.verify((Object)((Initialisable)this.connectionProvider.get()))).initialise();
        }
    }

    @Test
    public void valueStarted() throws Exception {
        ((LifecycleAwareConfigurationInstance)this.interceptable).start();
        ((Startable)Mockito.verify((Object)this.value)).start();
        if (this.connectionProvider.isPresent()) {
            ((Startable)Mockito.verify((Object)((Startable)this.connectionProvider.get()))).start();
        }
    }

    @Test
    public void testConnectivityUponStart() throws Exception {
        if (this.connectionProvider.isPresent()) {
            this.valueStarted();
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager)).testConnectivity((ConfigurationInstance)this.interceptable);
        }
    }

    @Test
    public void testConnectivityFailsUponStart() throws Exception {
        if (this.connectionProvider.isPresent()) {
            ConnectionException connectionException = new ConnectionException("Oops!");
            Mockito.when((Object)this.connectionManager.testConnectivity((ConfigurationInstance)this.interceptable)).thenReturn((Object)ConnectionValidationResult.failure((String)connectionException.getMessage(), (Exception)connectionException));
            try {
                ((LifecycleAwareConfigurationInstance)this.interceptable).start();
                Assert.fail((String)"Was expecting connectivity testing to fail");
            }
            catch (Exception e) {
                ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.times((int)6))).testConnectivity((ConfigurationInstance)this.interceptable);
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
            }
        }
    }

    @Test
    public void valueStopped() throws Exception {
        ((LifecycleAwareConfigurationInstance)this.interceptable).start();
        ((LifecycleAwareConfigurationInstance)this.interceptable).stop();
        ((Stoppable)Mockito.verify((Object)this.value)).stop();
        if (this.connectionProvider.isPresent()) {
            ((Stoppable)Mockito.verify((Object)((Stoppable)this.connectionProvider.get()))).stop();
        }
    }

    @Test
    public void connectionUnbound() throws Exception {
        ((LifecycleAwareConfigurationInstance)this.interceptable).start();
        ((LifecycleAwareConfigurationInstance)this.interceptable).stop();
        if (this.connectionProvider.isPresent()) {
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager)).unbind((Object)this.value);
        } else {
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.never())).unbind(Matchers.anyObject());
        }
    }

    @Test
    public void valueDisposed() throws Exception {
        ((LifecycleAwareConfigurationInstance)this.interceptable).initialise();
        ((LifecycleAwareConfigurationInstance)this.interceptable).dispose();
        ((Disposable)Mockito.verify((Object)this.value)).dispose();
        if (this.connectionProvider.isPresent()) {
            ((Disposable)Mockito.verify((Object)((Disposable)this.connectionProvider.get()))).dispose();
        }
    }

    @Test
    public void disposeMetadataCacheWhenConfigIsDisposed() throws Exception {
        MuleMetadataService muleMetadataManager = (MuleMetadataService)muleContext.getRegistry().lookupObject(MuleMetadataService.class);
        muleMetadataManager.getMetadataCache(NAME);
        ((LifecycleAwareConfigurationInstance)this.interceptable).start();
        ((LifecycleAwareConfigurationInstance)this.interceptable).stop();
        new PollingProber(1000L, 100L).check((Probe)new JUnitLambdaProbe(() -> muleMetadataManager.getMetadataCaches().entrySet().isEmpty()));
    }

    @Test
    public void getName() {
        Assert.assertThat((Object)((LifecycleAwareConfigurationInstance)this.interceptable).getName(), (Matcher)CoreMatchers.is((Object)NAME));
    }

    @Test
    public void getModel() {
        Assert.assertThat((Object)((LifecycleAwareConfigurationInstance)this.interceptable).getModel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configurationModel)));
    }

    @Test
    public void getValue() {
        Assert.assertThat((Object)((LifecycleAwareConfigurationInstance)this.interceptable).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.value)));
    }

    @Test(expected=IllegalStateException.class)
    public void getStatsBeforeInit() {
        ((LifecycleAwareConfigurationInstance)this.interceptable).getStatistics();
    }

    @Test
    public void getStatistics() throws Exception {
        ((LifecycleAwareConfigurationInstance)this.interceptable).initialise();
        Assert.assertThat((Object)((LifecycleAwareConfigurationInstance)this.interceptable).getStatistics(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void getState() {
        Assert.assertThat((Object)((LifecycleAwareConfigurationInstance)this.interceptable).getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configurationState)));
    }
}

