/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionHandlerManager;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExceptionHandlerManagerTestCase {
    private static final String ERROR_MESSAGE = "ERROR MESSAGE";
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private SourceModel sourceModel;
    @Mock
    private ExceptionHandlerFactory extensionFactory;
    @Mock
    private ExceptionHandler extensionEnricher;
    @Mock
    private ExceptionHandlerFactory sourceFactory;
    @Mock
    private ExceptionHandler sourceEnricher;
    private ExceptionHandlerManager manager;

    @Before
    public void beforeTest() {
        Mockito.when((Object)this.extensionFactory.createHandler()).thenReturn((Object)this.extensionEnricher);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, this.extensionFactory);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, this.sourceFactory);
        Mockito.when((Object)this.sourceEnricher.enrichException((Exception)Matchers.any(Exception.class))).thenReturn((Object)new HeisenbergException(ERROR_MESSAGE));
        Mockito.when((Object)this.sourceFactory.createHandler()).thenReturn((Object)this.sourceEnricher);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"Test Extension");
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"Test Source");
        this.manager = new ExceptionHandlerManager(this.extensionModel, (ComponentModel)this.sourceModel);
    }

    @Test
    public void processAndEnrich() {
        ConnectionException connectionException = new ConnectionException("Connection Error");
        Throwable throwable = this.manager.process((Throwable)connectionException);
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)connectionException))));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(HeisenbergException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
    }

    @Test
    public void handleConnectionException() {
        ConnectionException rootCause = new ConnectionException(ERROR_MESSAGE, (Throwable)new Exception());
        Throwable throwable = this.manager.handleThrowable(new Throwable(new RuntimeException(new ExecutionException((Throwable)rootCause))));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)rootCause)));
    }

    @Test
    public void handleInvocationTargetExceptionCause() {
        IOException rootCause = new IOException(ERROR_MESSAGE, new Exception());
        Throwable throwable = this.manager.handleThrowable(new Throwable(new Exception(new UndeclaredThrowableException(rootCause))));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(IOException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)rootCause)));
    }

    @Test
    public void findCorrectEnricher() {
        MatcherAssert.assertThat((Object)this.manager.getExceptionHandler(), (Matcher)Is.is((Object)this.sourceEnricher));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, null);
        ExceptionHandlerManager manager = new ExceptionHandlerManager(this.extensionModel, (ComponentModel)this.sourceModel);
        MatcherAssert.assertThat((Object)manager.getExceptionHandler(), (Matcher)Is.is((Object)this.extensionEnricher));
    }

    @Test
    public void processError() {
        Error rootCause = new Error(ERROR_MESSAGE, new Exception());
        Throwable throwable = this.manager.process((Throwable)rootCause);
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)throwable, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)rootCause)));
    }
}

