/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public abstract class ValueReturnDelegateContractTestCase
extends AbstractMuleContextTestCase {
    @Mock
    protected ExecutionContextAdapter operationContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ComponentModel componentModel;
    protected InternalEvent event;
    @Mock
    protected Object attributes;
    protected ReturnDelegate delegate;

    @Before
    public void before() throws MuleException {
        this.event = ValueReturnDelegateContractTestCase.eventBuilder().message(Message.builder().value((Object)"").attributesValue(this.attributes).build()).build();
        this.delegate = this.createReturnDelegate();
        Mockito.when((Object)this.operationContext.getEvent()).thenReturn((Object)this.event);
        Mockito.when((Object)this.operationContext.getMuleContext()).thenReturn((Object)muleContext);
    }

    @Test
    public void returnsSingleValue() {
        byte[] value = new byte[]{};
        InternalEvent result = this.delegate.asReturnValue((Object)value, this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(byte[].class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationReturnsOperationResultButKeepsAttributes() throws Exception {
        Object payload = new Object();
        MediaType mediaType = MediaType.ANY.withCharset(SystemUtils.getDefaultEncoding((MuleContext)muleContext));
        InternalEvent result = this.delegate.asReturnValue((Object)Result.builder().output(payload).mediaType(mediaType).build(), this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)mediaType));
    }

    @Test
    public void operationReturnsOperationResultThatOnlySpecifiesPayload() throws Exception {
        String payload = "hello world!";
        InternalEvent result = this.delegate.asReturnValue((Object)Result.builder().output((Object)payload).build(), this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationReturnsOperationResultThatOnlySpecifiesPayloadAndAttributes() throws Exception {
        String payload = "hello world!";
        Object newAttributes = Mockito.mock(Object.class);
        InternalEvent result = this.delegate.asReturnValue((Object)Result.builder().output((Object)payload).attributes(newAttributes).build(), this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)newAttributes)));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }

    protected abstract ReturnDelegate createReturnDelegate();

    protected abstract Message getOutputMessage(InternalEvent var1);
}

