/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.registry.ResolverException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ConfigOverrideValueResolverWrapper<T>
implements ValueResolver<T>,
Initialisable {
    private final ValueResolver<T> delegate;
    private final String parameterName;
    private final MuleContext muleContext;
    private Function<Object, Object> defaultValueResolver;

    public static <T> ValueResolver<T> of(ValueResolver<T> delegate, String parameterName, MuleContext muleContext) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (String)"A ValueResolver is required in order to delegate the value resolution.");
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)parameterName) ? 1 : 0) != 0, (String)"A parameter name is required in order to use the config as a fallback.");
        return new ConfigOverrideValueResolverWrapper<T>(delegate, parameterName, muleContext);
    }

    private ConfigOverrideValueResolverWrapper(ValueResolver<T> delegate, String parameterName, MuleContext muleContext) {
        this.muleContext = muleContext;
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (String)"A ConfigOverride value resolver requires a non-null delegate");
        this.delegate = delegate;
        this.parameterName = parameterName;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        T value = this.delegate.resolve(context);
        if (value != null) {
            return value;
        }
        if (!context.getConfig().isPresent()) {
            throw new ResolverException(I18nMessageFactory.createStaticMessage((String)("Failed to obtain the config-provided value for parameter [" + this.parameterName + "]. No configuration was available in the current resolution context.")));
        }
        return this.resolveConfigOverrideParameter(context.getConfig().get());
    }

    @Override
    public boolean isDynamic() {
        return this.delegate.isDynamic();
    }

    public void initialise() throws InitialisationException {
        try {
            this.muleContext.getInjector().inject(this.delegate);
            LifecycleUtils.initialiseIfNeeded(this.delegate, (MuleContext)this.muleContext);
        }
        catch (MuleException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Failed to initialise the delegate ValueResolver for ConfigOverride wrapper"), (Throwable)e, (Initialisable)this);
        }
    }

    private T resolveConfigOverrideParameter(ConfigurationInstance instance) {
        try {
            return (T)this.getParameterValueResolverFromConfig(instance).apply(instance.getValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to obtain the value for parameter [" + this.parameterName + "] from the associated configuration [" + instance.getName() + "]: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function<Object, Object> getParameterValueResolverFromConfig(ConfigurationInstance config) {
        if (this.defaultValueResolver != null) {
            return this.defaultValueResolver;
        }
        ConfigOverrideValueResolverWrapper configOverrideValueResolverWrapper = this;
        synchronized (configOverrideValueResolverWrapper) {
            if (this.defaultValueResolver == null) {
                for (ParameterGroupModel group : config.getModel().getParameterGroupModels()) {
                    Optional<String> fieldName = group.getParameterModels().stream().filter(p -> p.getName().equals(this.parameterName)).findFirst().map(p -> ((DeclaringMemberModelProperty)p.getModelProperty(DeclaringMemberModelProperty.class).get()).getDeclaringField().getName());
                    if (!fieldName.isPresent()) continue;
                    this.defaultValueResolver = group.getName().equals("General") ? this.getParameterValueFromConfigField(config, fieldName.get()) : this.getParameterValueFromFieldInGroup(config, group, fieldName.get());
                    break;
                }
            }
        }
        if (this.defaultValueResolver == null) {
            throw new IllegalArgumentException("Missing parameter with name [" + this.parameterName + "] in config [" + config.getName() + "]");
        }
        return this.defaultValueResolver;
    }

    private Function<Object, Object> getParameterValueFromConfigField(ConfigurationInstance config, String fieldName) {
        Field parameterField = IntrospectionUtils.getField(config.getValue().getClass(), fieldName).orElseThrow(() -> new IllegalArgumentException("Missing field with name [" + fieldName + "] in config [" + config.getName() + "]"));
        parameterField.setAccessible(true);
        return target -> {
            try {
                return parameterField.get(target);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to read field with name [" + parameterField.getName() + " in config [" + config.getName() + "]: " + e.getMessage());
            }
        };
    }

    private Function<Object, Object> getParameterValueFromFieldInGroup(ConfigurationInstance config, ParameterGroupModel group, String fieldName) {
        ParameterGroupDescriptor descriptor = group.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).orElseThrow(() -> new IllegalArgumentException(String.format("The group [%s] in config [%s] doesn't provide a group descriptor. Is not possible to retrieve the config parameter to override", group.getName(), config.getName())));
        Field groupField = (Field)descriptor.getContainer();
        Field parameterField = IntrospectionUtils.getField(descriptor.getType().getDeclaringClass(), fieldName).orElseThrow(() -> new IllegalArgumentException("Missing field with name [" + fieldName + "] in group [" + descriptor.getName() + "] of config [" + config.getName() + "]"));
        return new ParameterValueRetrieverFromConfigGroup(groupField, parameterField);
    }

    private static final class ParameterValueRetrieverFromConfigGroup
    implements Function {
        private final Field groupField;
        private final Field parameterField;

        public ParameterValueRetrieverFromConfigGroup(Field groupField, Field parameterField) {
            this.groupField = groupField;
            this.parameterField = parameterField;
            this.groupField.setAccessible(true);
            this.parameterField.setAccessible(true);
        }

        public Object apply(Object configInstance) {
            Object groupInstance;
            try {
                groupInstance = this.groupField.get(configInstance);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Missing field with name [" + this.groupField.getName() + "] of config [" + this.groupField.getDeclaringClass().getName() + "]: " + e.getMessage());
            }
            try {
                return this.parameterField.get(groupInstance);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Missing field with name [" + this.parameterField.getName() + "] in group [" + this.parameterField.getDeclaringClass().getName() + "] of config [" + this.groupField.getDeclaringClass().getName() + "]: " + e.getMessage());
            }
        }
    }
}

