/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionTypedValueValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ResolverUtils {
    private ResolverUtils() {
    }

    static ValueResolver<?> getFieldDefaultValueValueResolver(ObjectFieldType field, MuleContext muleContext) {
        Optional defaultValue = MetadataTypeUtils.getDefaultValue((MetadataType)field);
        Preconditions.checkArgument((boolean)defaultValue.isPresent(), (String)("No default value available for field :" + field.getKey().getName()));
        return ResolverUtils.getExpressionBasedValueResolver((String)defaultValue.get(), field.getValue(), muleContext);
    }

    static ValueResolver<?> getFieldDefaultValueValueResolver(MetadataType fieldType, String defaultValue, MuleContext muleContext) {
        return ResolverUtils.getExpressionBasedValueResolver(defaultValue, fieldType, muleContext);
    }

    public static ValueResolver<?> getExpressionBasedValueResolver(String expression, MetadataType metadataType, MuleContext muleContext) {
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType), () -> IntrospectionUtils.isParameterResolver(metadataType), metadataType, muleContext);
    }

    static ValueResolver<?> getExpressionBasedValueResolver(String expression, ParameterModel operationModel, MuleContext muleContext) {
        MetadataType metadataType = operationModel.getType();
        Set modelProperties = operationModel.getModelProperties();
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType) || IntrospectionUtils.isTypedValue(modelProperties), () -> IntrospectionUtils.isParameterResolver(metadataType) || IntrospectionUtils.isParameterResolver(modelProperties), metadataType, muleContext);
    }

    static ValueResolver<?> getDefaultValueResolver(boolean hasDefaultEncoding, MuleContext muleContext, Supplier<ValueResolver<?>> supplier) {
        return hasDefaultEncoding ? new StaticValueResolver<String>(muleContext.getConfiguration().getDefaultEncoding()) : supplier.get();
    }

    private static ValueResolver<?> getExpressionBasedValueResolver(String expression, BooleanSupplier isTypedValue, BooleanSupplier isParameterResolver, MetadataType type, MuleContext muleContext) {
        try {
            if (isTypedValue.getAsBoolean()) {
                ExpressionTypedValueValueResolver valueResolver = new ExpressionTypedValueValueResolver(expression, JavaTypeUtils.getType((MetadataType)type));
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                return valueResolver;
            }
            if (isParameterResolver.getAsBoolean()) {
                ExpressionBasedParameterResolverValueResolver valueResolver = new ExpressionBasedParameterResolverValueResolver(expression, type);
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                return valueResolver;
            }
            if (muleContext.getExpressionManager().isExpression(expression)) {
                TypeSafeExpressionValueResolver valueResolver = new TypeSafeExpressionValueResolver(expression, type);
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                valueResolver.initialise();
                return valueResolver;
            }
            TypeSafeValueResolverWrapper typeSafeValueResolverWrapper = new TypeSafeValueResolverWrapper(new StaticValueResolver<String>(expression), JavaTypeUtils.getType((MetadataType)type));
            typeSafeValueResolverWrapper.setTransformationService(muleContext.getTransformationService());
            typeSafeValueResolverWrapper.initialise();
            return typeSafeValueResolverWrapper;
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

