/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ConnectionProviderModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class ConnectionProviderModelValidatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ExtensionModelValidator validator = new ConnectionProviderModelValidator();

    @Test
    public void validModel() throws Exception {
        this.validate(ValidTestConnector.class);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidConnectedOperation() {
        this.validate(InvalidConfigConnectionProviderTestConnector.class);
    }

    @Test
    public void invalidConnectionTypeProviderTestConnector() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"requires a connection of type"));
        this.validate(InvalidConnectionTypeProviderTestConnector.class);
    }

    @Test
    public void validTransactionalProvider() {
        this.validate(ValidTransactionalProviderConnector.class);
    }

    private void validate(Class<?> connectorClass) {
        ExtensionsTestUtils.validate(connectorClass, this.validator);
    }

    public static class ValidatorTestConnection {
    }

    public static class ValidTransactionalProvider
    implements PoolingConnectionProvider<TransactionalConnection> {
        public TransactionalConnection connect() throws ConnectionException {
            return (TransactionalConnection)Mockito.mock(TransactionalConnection.class);
        }

        public void disconnect(TransactionalConnection connection) {
        }

        public ConnectionValidationResult validate(TransactionalConnection connection) {
            return ConnectionValidationResult.success();
        }
    }

    @Alias(value="invalidConnection")
    public static class InvalidTypeConnectionProvider
    implements ConnectionProvider<Apple> {
        public Apple connect() throws ConnectionException {
            return new Apple();
        }

        public void disconnect(Apple connection) {
        }

        public ConnectionValidationResult validate(Apple apple) {
            return ConnectionValidationResult.success();
        }
    }

    @Alias(value="invalidConfig")
    public static class InvalidConfigConnectionProvider
    implements ConnectionProvider<Apple> {
        public Apple connect() throws ConnectionException {
            return new Apple();
        }

        public void disconnect(Apple connection) {
        }

        public ConnectionValidationResult validate(Apple validatorTestConnection) {
            return ConnectionValidationResult.success();
        }
    }

    @Alias(value="provider2")
    public static class TestConnectionProvider2
    extends TestConnectionProvider {
    }

    @Alias(value="provider1")
    public static class TestConnectionProvider
    implements ConnectionProvider<ValidatorTestConnection> {
        public ValidatorTestConnection connect() throws ConnectionException {
            return new ValidatorTestConnection();
        }

        public void disconnect(ValidatorTestConnection connection) {
        }

        public ConnectionValidationResult validate(ValidatorTestConnection validatorTestConnection) {
            return ConnectionValidationResult.success();
        }
    }

    @Configuration(name="config2")
    @Operations(value={ValidTestOperations.class})
    public static class TestConfig2
    implements Config {
    }

    @Configuration(name="config")
    @Operations(value={ValidTestOperations.class})
    public static class TestConfig
    implements Config {
    }

    @Extension(name="validatorTest")
    @Configurations(value={TestConfig.class, TestConfig2.class})
    @ConnectionProviders(value={TestConnectionProvider.class, TestConnectionProvider2.class, InvalidTypeConnectionProvider.class})
    public static class InvalidConnectionTypeProviderTestConnector {
    }

    @Extension(name="validTransactionalProvider")
    @ConnectionProviders(value={TestConnectionProvider.class, TestConnectionProvider2.class, ValidTransactionalProvider.class})
    public static class ValidTransactionalProviderConnector {
    }

    @Extension(name="validatorTest")
    @Configurations(value={TestConfig.class, TestConfig2.class})
    @Operations(value={ValidTestOperations.class})
    @ConnectionProviders(value={TestConnectionProvider.class, TestConnectionProvider2.class, InvalidConfigConnectionProvider.class})
    public static class InvalidConfigConnectionProviderTestConnector {
    }

    public static class InvalidConnectionOperation {
        public void invalid(@Connection Apple apple) {
        }
    }

    @Extension(name="validatorTest")
    @Configurations(value={TestConfig.class, TestConfig2.class})
    @Operations(value={ValidTestOperations.class, InvalidConnectionOperation.class})
    public static class InvalidConnectedOperationTestConnector {
    }

    public static class ValidTestOperations {
        public void foo(@Connection ValidatorTestConnection connection) {
        }

        public void bar(@Connection ValidatorTestConnection connection) {
        }
    }

    @Extension(name="validatorTest")
    @Configurations(value={TestConfig.class, TestConfig2.class})
    @ConnectionProviders(value={TestConnectionProvider.class, TestConnectionProvider2.class})
    public static class ValidTestConnector {
    }

    static interface Config {
    }
}

