/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.internal.loader.validator.OperationModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationModelValidatorTestCase
extends AbstractMuleTestCase {
    public static final String EXTENSION_NAME = "extension";
    public static final String OPERATION_NAME = "operation";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationModel configurationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationModel operationModel;
    @Mock
    private ParameterModel goodParameter;
    private ExtensionModelValidator validator = new OperationModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.operationModel.getOutputAttributes().getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(Void.TYPE));
        Mockito.when((Object)this.goodParameter.getName()).thenReturn((Object)"valid");
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.goodParameter));
    }

    private void validate() {
        ExtensionsTestUtils.validate(this.extensionModel, this.validator);
    }

    @Test
    public void validOperationParameters() {
        this.validate();
    }

    @Test
    public void globalConnectedOperationWithGlobalConnectionProvider() {
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModel.getConnectionProviders()).thenReturn(Collections.singletonList(Mockito.mock(ConnectionProviderModel.class)));
        this.validate();
    }

    @Test
    public void globalConnectedOperationWithoutConnectionProvider() {
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.validate();
    }

    @Test
    public void configLevelOperationWithGlobalConnectionProvider() {
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getConnectionProviders()).thenReturn(Collections.singletonList(Mockito.mock(ConnectionProviderModel.class)));
        this.validate();
    }

    @Test
    public void configLevelOperationWithoutConnectionProvider() {
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.configurationModel.getConnectionProviders()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Collections.singletonList(this.configurationModel));
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.validate();
    }

    @Test
    public void configLevelOperationWithConfigLevelConnectionProvider() {
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.configurationModel.getConnectionProviders()).thenReturn(Collections.singletonList(Mockito.mock(ConnectionProviderModel.class)));
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        this.validate();
    }

    @Test
    public void validForParameterLessOperation() {
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn((Object)ImmutableList.of());
        this.validate();
    }
}

