/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.AbstractValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public abstract class AbstractValueResolverWrapperTestCase<T>
extends AbstractMuleContextTestCase {
    protected AbstractValueResolverWrapper<T> wrapper;
    protected ValueResolver<T> delegate;

    @Before
    public void before() throws Exception {
        MuleTestUtils.spyInjector((MuleContext)muleContext);
        this.delegate = this.createDelegate();
        this.wrapper = this.createWrapper(this.delegate);
        muleContext.getInjector().inject(this.wrapper);
    }

    protected abstract AbstractValueResolverWrapper<T> createWrapper(ValueResolver<T> var1);

    protected abstract ValueResolver<T> createDelegate();

    @Test
    public void initialise() throws Exception {
        this.wrapper.initialise();
        if (this.delegate instanceof Initialisable) {
            ((Initialisable)Mockito.verify((Object)((Initialisable)this.delegate))).initialise();
        }
        ((Injector)Mockito.verify((Object)muleContext.getInjector())).inject(this.delegate);
    }

    @Test
    public void start() throws Exception {
        this.wrapper.start();
        if (this.delegate instanceof Startable) {
            ((Startable)Mockito.verify((Object)((Startable)this.delegate))).start();
        }
    }

    @Test
    public void stop() throws Exception {
        this.wrapper.stop();
        if (this.delegate instanceof Stoppable) {
            ((Stoppable)Mockito.verify((Object)((Stoppable)this.delegate))).stop();
        }
    }

    @Test
    public void dispose() throws Exception {
        this.wrapper.dispose();
        if (this.delegate instanceof Disposable) {
            ((Disposable)Mockito.verify((Object)((Disposable)this.delegate))).dispose();
        }
    }
}

