/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionArgumentResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionArgumentResolverTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExecutionContextAdapter operationContext;
    private ConnectionArgumentResolver resolver = new ConnectionArgumentResolver();

    @Test
    public void resolve() throws Exception {
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Object connection = new Object();
        Mockito.when((Object)connectionHandler.getConnection()).thenReturn(connection);
        Mockito.when((Object)this.operationContext.getVariable("MULE_CONNECTION_PARAM")).thenReturn((Object)connectionHandler);
        Assert.assertThat((Object)this.resolver.resolve((ExecutionContext)this.operationContext), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)connection)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void noConnection() {
        Mockito.when((Object)this.operationContext.getVariable("MULE_CONNECTION_PARAM")).thenReturn(null);
        this.resolver.resolve((ExecutionContext)this.operationContext);
    }
}

