/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.internal.runtime.resolver.ProcessorChainValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@RunWith(value=MockitoJUnitRunner.class)
public class NestedProcessorValueResolverTestCase
extends AbstractMuleContextTestCase {
    @Mock
    private MessageProcessorChain messageProcessor;

    @Before
    public void before() throws Exception {
        CoreEvent testEvent = this.testEvent();
        Mockito.when((Object)this.messageProcessor.process((CoreEvent)Matchers.any(CoreEvent.class))).thenReturn((Object)testEvent);
        Mockito.when((Object)this.messageProcessor.apply((Publisher)Matchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)testEvent));
    }

    @Test
    public void yieldsNestedProcessor() throws Exception {
        ProcessorChainValueResolver resolver = new ProcessorChainValueResolver(this.messageProcessor);
        muleContext.getInjector().inject((Object)resolver);
        CoreEvent event = this.testEvent();
        Chain nestedProcessor = resolver.resolve(ValueResolvingContext.from((CoreEvent)event));
        nestedProcessor.process(result -> {
            Assert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)"test"));
            ArgumentCaptor captor = ArgumentCaptor.forClass(CoreEvent.class);
            try {
                ((MessageProcessorChain)Mockito.verify((Object)this.messageProcessor)).process((CoreEvent)captor.capture());
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
            CoreEvent capturedEvent = (CoreEvent)captor.getValue();
            Assert.assertThat((Object)capturedEvent, (Matcher)CoreMatchers.is((Object)event));
        }, (e, r) -> Assert.fail((String)e.getMessage()));
    }

    @Test
    public void alwaysGivesDifferentInstances() throws Exception {
        ProcessorChainValueResolver resolver = new ProcessorChainValueResolver(this.messageProcessor);
        muleContext.getInjector().inject((Object)resolver);
        Chain resolved1 = resolver.resolve(ValueResolvingContext.from((CoreEvent)this.testEvent()));
        Chain resolved2 = resolver.resolve(ValueResolvingContext.from((CoreEvent)this.testEvent()));
        Assert.assertThat((Object)resolved1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)resolved2))));
    }
}

