/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import javax.resource.spi.work.Work;
import org.assertj.core.api.ThrowableAssert;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.streaming.bytes.factory.NullCursorStreamProviderFactory;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.execution.MessageProcessContext;
import org.mule.runtime.core.privileged.execution.MessageProcessingManager;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandlerFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallback;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.core.streaming.SimpleByteBufferManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.test.heisenberg.extension.exception.HeisenbergConnectionExceptionEnricher;
import org.mule.test.metadata.extension.resolver.TestNoConfigMetadataResolver;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionMessageSourceTestCase
extends AbstractMuleContextTestCase {
    private static final String CONFIG_NAME = "myConfig";
    private static final String ERROR_MESSAGE = "ERROR";
    private static final String SOURCE_NAME = "source";
    private static final String METADATA_KEY = "metadataKey";
    private final SimpleRetryPolicyTemplate retryPolicyTemplate = new SimpleRetryPolicyTemplate(0L, 2);
    private final JavaTypeLoader typeLoader = new JavaTypeLoader(((Object)((Object)this)).getClass().getClassLoader());
    private CursorStreamProviderFactory cursorStreamProviderFactory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SourceModel sourceModel;
    @Mock
    private SourceAdapterFactory sourceAdapterFactory;
    @Mock
    private SourceCallbackFactory sourceCallbackFactory;
    @Mock
    private MessageProcessContext messageProcessContext;
    @Mock
    private TransactionConfig transactionConfig;
    @Mock
    private Scheduler ioScheduler;
    @Mock
    private Scheduler cpuLightScheduler;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Processor messageProcessor;
    @Mock
    private SourceCompletionHandlerFactory completionHandlerFactory;
    @Mock
    private FlowConstruct flowConstruct;
    @Mock
    private Source source;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionManager extensionManager;
    @Mock
    private MessageProcessingManager messageProcessingManager;
    @Mock
    private ExceptionCallback exceptionCallback;
    @Mock
    private ExceptionHandlerFactory enricherFactory;
    @Mock
    private ConfigurationProvider configurationProvider;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationModel configurationModel;
    @Mock
    private ConfigurationInstance configurationInstance;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResolverSet callbackParameters;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Result result;
    @Mock
    protected MetadataResolverFactory metadataResolverFactory;
    private SourceAdapter sourceAdapter;
    private SourceCallback sourceCallback;
    private ExtensionMessageSource messageSource;
    private StreamingManager streamingManager = (StreamingManager)Mockito.spy((Object)new DefaultStreamingManager());

    @Before
    public void before() throws Exception {
        MuleTestUtils.spyInjector((MuleContext)muleContext);
        Mockito.reset((Object[])new SchedulerService[]{muleContext.getSchedulerService()});
        Mockito.when((Object)this.result.getMediaType()).thenReturn(Optional.of(MediaType.ANY));
        Mockito.when((Object)this.result.getAttributes()).thenReturn(Optional.empty());
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("_muleStreamingManager", (Object)this.streamingManager);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        this.cursorStreamProviderFactory = ExtensionsTestUtils.getDefaultCursorStreamProviderFactory(this.streamingManager);
        this.sourceAdapter = this.createSourceAdapter();
        Mockito.when((Object)this.sourceAdapterFactory.createAdapter((Optional)Matchers.any(), (SourceCallbackFactory)Matchers.any(), (ComponentLocation)Matchers.any(), (SourceConnectionManager)Matchers.any(), (MessagingExceptionResolver)Matchers.any())).thenReturn((Object)this.sourceAdapter);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, null);
        Mockito.when((Object)this.sourceModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getModelProperty(SourceCallbackModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.empty());
        ExtensionsTestUtils.setRequires((EnrichableModel)this.sourceModel, true, true);
        Mockito.when((Object)this.sourceModel.getOutput().getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(String.class));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, null);
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel, ((Object)((Object)this)).getClass().getClassLoader());
        this.retryPolicyTemplate.setNotificationFirer((NotificationDispatcher)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationDispatcher.class));
        LifecycleUtils.initialiseIfNeeded((Object)this.retryPolicyTemplate, (MuleContext)muleContext);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("_muleExtensionManager", (Object)this.extensionManager);
        Mockito.when((Object)this.flowConstruct.getMuleContext()).thenReturn((Object)muleContext);
        ExtensionsTestUtils.mockSubTypes(this.extensionModel, new SubTypesModel[0]);
        Mockito.when((Object)this.configurationModel.getSourceModel(SOURCE_NAME)).thenReturn(Optional.of(this.sourceModel));
        Mockito.when((Object)this.extensionManager.getConfigurationProvider(CONFIG_NAME)).thenReturn(Optional.of(this.configurationProvider));
        Mockito.when((Object)this.configurationProvider.get((Event)Matchers.any())).thenReturn((Object)this.configurationInstance);
        Mockito.when((Object)this.configurationProvider.getConfigurationModel()).thenReturn((Object)this.configurationModel);
        Mockito.when((Object)this.configurationProvider.getName()).thenReturn((Object)CONFIG_NAME);
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, this.metadataResolverFactory);
        Mockito.when((Object)this.metadataResolverFactory.getKeyResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getInputResolver("content")).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getInputResolver("type")).thenReturn((Object)new NullMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getOutputResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getOutputAttributesResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Output", (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build(), true, Collections.emptySet()));
        Mockito.when((Object)this.sourceModel.getOutputAttributes()).thenReturn((Object)new ImmutableOutputModel("Output", (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build(), false, Collections.emptySet()));
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty(this.typeLoader.load(String.class), METADATA_KEY)));
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.messageProcessContext.getTransactionConfig()).thenReturn(Optional.empty());
        this.messageSource = this.getNewExtensionMessageSourceInstance();
        this.sourceCallback = (SourceCallback)Mockito.spy((Object)DefaultSourceCallback.builder().setSourceModel(this.sourceModel).setProcessingManager(this.messageProcessingManager).setListener(this.messageProcessor).setSource(this.messageSource).setMuleContext(muleContext).setProcessContextSupplier(() -> this.messageProcessContext).setCompletionHandlerFactory(this.completionHandlerFactory).setExceptionCallback(this.exceptionCallback).setCursorStreamProviderFactory((CursorProviderFactory)this.cursorStreamProviderFactory).build());
        Mockito.when((Object)this.sourceCallbackFactory.createSourceCallback((SourceCompletionHandlerFactory)Matchers.any())).thenReturn((Object)this.sourceCallback);
    }

    @After
    public void after() throws MuleException {
        this.messageSource.stop();
        this.messageSource.dispose();
    }

    @Test
    public void handleMessage() throws Exception {
        ((Source)Mockito.doAnswer(invocationOnMock -> {
            this.sourceCallback.handle(this.result);
            return null;
        }).when((Object)this.source)).onStart(this.sourceCallback);
        ((Scheduler)Mockito.doAnswer(invocation -> {
            ((Work)invocation.getArguments()[0]).run();
            return null;
        }).when((Object)this.cpuLightScheduler)).execute((Runnable)Matchers.any());
        this.messageSource.initialise();
        this.messageSource.start();
        ((SourceCallback)Mockito.verify((Object)this.sourceCallback)).handle(this.result);
    }

    @Test
    public void handleExceptionAndRestart() throws Exception {
        this.initialise();
        this.start();
        this.messageSource.onException(new ConnectionException(ERROR_MESSAGE));
        ((Source)Mockito.verify((Object)this.source)).onStop();
        ((Scheduler)Mockito.verify((Object)this.ioScheduler, (VerificationMode)Mockito.never())).stop();
        ((Scheduler)Mockito.verify((Object)this.cpuLightScheduler, (VerificationMode)Mockito.never())).stop();
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)2))).onStart(this.sourceCallback);
        this.handleMessage();
    }

    @Test
    public void initialise() throws Exception {
        this.messageSource.initialise();
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.never())).onStart(this.sourceCallback);
    }

    @Test
    public void sourceIsInstantiatedOnce() throws Exception {
        this.initialise();
        this.start();
        ((SourceAdapterFactory)Mockito.verify((Object)this.sourceAdapterFactory, (VerificationMode)Mockito.times((int)1))).createAdapter((Optional)Matchers.any(), (SourceCallbackFactory)Matchers.any(), (ComponentLocation)Matchers.any(), (SourceConnectionManager)Matchers.any(), (MessagingExceptionResolver)Matchers.any());
    }

    @Test
    public void failToStart() throws Exception {
        DefaultMuleException e = new DefaultMuleException((Throwable)new Exception());
        ((Source)Mockito.doThrow((Throwable)e).when((Object)this.source)).onStart((SourceCallback)Matchers.any());
        this.expectedException.expect(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
        this.messageSource.initialise();
        this.messageSource.start();
    }

    @Test
    public void failWithConnectionExceptionWhenStartingAndGetRetryPolicyExhausted() throws Exception {
        ConnectionException connectionException = new ConnectionException(ERROR_MESSAGE);
        ((Source)Mockito.doThrow((Throwable)new RuntimeException((Throwable)connectionException)).when((Object)this.source)).onStart(this.sourceCallback);
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)this.messageSource).start());
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is(this.exhaustedBecauseOf((Throwable)connectionException)));
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)3))).onStart(this.sourceCallback);
    }

    @Test
    public void failWithNonConnectionExceptionWhenStartingAndGetRetryPolicyExhausted() throws Exception {
        ((Source)Mockito.doThrow((Throwable)new DefaultMuleException((Throwable)new IOException(ERROR_MESSAGE))).when((Object)this.source)).onStart(this.sourceCallback);
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)this.messageSource).start());
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
        Assert.assertThat((Object)org.apache.commons.lang3.exception.ExceptionUtils.getThrowables((Throwable)throwable), (Matcher)org.hamcrest.Matchers.hasItemInArray((Matcher)CoreMatchers.instanceOf(IOException.class)));
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)3))).onStart(this.sourceCallback);
    }

    @Test
    public void failWithConnectionExceptionWhenStartingAndGetsReconnected() throws Exception {
        ((Source)Mockito.doThrow((Throwable)new RuntimeException((Throwable)new ConnectionException(ERROR_MESSAGE))).doThrow((Throwable)new RuntimeException((Throwable)new ConnectionException(ERROR_MESSAGE))).doNothing().when((Object)this.source)).onStart(this.sourceCallback);
        this.messageSource.initialise();
        this.messageSource.start();
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)3))).onStart(this.sourceCallback);
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)2))).onStop();
    }

    @Test
    public void failOnExceptionWithConnectionExceptionAndGetsReconnected() throws Exception {
        this.messageSource.initialise();
        this.messageSource.start();
        this.messageSource.onException(new ConnectionException(ERROR_MESSAGE));
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)2))).onStart(this.sourceCallback);
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)1))).onStop();
    }

    @Test
    public void startFailsWithRandomException() throws Exception {
        final RuntimeException e = new RuntimeException();
        ((Source)Mockito.doThrow((Throwable)e).when((Object)this.source)).onStart(this.sourceCallback);
        this.expectedException.expect(this.exhaustedBecauseOf((Matcher<Throwable>)new BaseMatcher<Throwable>(){
            private Matcher<Exception> exceptionMatcher;
            {
                this.exceptionMatcher = ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.sameInstance((Object)e));
            }

            public boolean matches(Object item) {
                return this.exceptionMatcher.matches(item);
            }

            public void describeTo(Description description) {
                this.exceptionMatcher.describeTo(description);
            }
        }));
        this.initialise();
        this.messageSource.start();
    }

    @Test
    public void start() throws Exception {
        this.initialise();
        this.messageSource.start();
        ((Source)Mockito.verify((Object)this.source)).onStart(this.sourceCallback);
        ((Injector)Mockito.verify((Object)muleContext.getInjector())).inject((Object)this.source);
    }

    @Test
    public void failedToCreateRetryScheduler() throws Exception {
        RuntimeException e = new RuntimeException();
        SchedulerService schedulerService = muleContext.getSchedulerService();
        ((SchedulerService)Mockito.doThrow((Throwable)e).when((Object)schedulerService)).cpuLightScheduler();
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)this.messageSource).start());
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    @Test
    public void failedToCreateFlowTrigger() throws Exception {
        RuntimeException e = new RuntimeException();
        SchedulerService schedulerService = muleContext.getSchedulerService();
        ((SchedulerService)Mockito.doThrow((Throwable)e).when((Object)schedulerService)).cpuLightScheduler();
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)this.messageSource).start());
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    @Test
    public void stop() throws Exception {
        this.messageSource.initialise();
        this.messageSource.start();
        this.messageSource.stop();
        ((Source)Mockito.verify((Object)this.source)).onStop();
    }

    @Test
    public void enrichExceptionWithSourceExceptionEnricher() throws Exception {
        Mockito.when((Object)this.enricherFactory.createHandler()).thenReturn((Object)new HeisenbergConnectionExceptionEnricher());
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, this.enricherFactory);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, this.enricherFactory);
        ExtensionMessageSource messageSource = this.getNewExtensionMessageSourceInstance();
        ((Source)Mockito.doThrow((Throwable)new RuntimeException(ERROR_MESSAGE)).when((Object)this.source)).onStart(this.sourceCallback);
        Throwable t = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)messageSource).start());
        Assert.assertThat((Object)ExceptionUtils.containsType((Throwable)t, ConnectionException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)t.getMessage(), (Matcher)StringContains.containsString((String)"Enriched Connection Exception: ERROR"));
        messageSource.stop();
    }

    @Test
    public void enrichExceptionWithExtensionEnricher() throws Exception {
        String enrichedErrorMessage = "Enriched: ERROR";
        ExceptionHandler exceptionEnricher = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        Mockito.when((Object)exceptionEnricher.enrichException((Exception)Matchers.any(Exception.class))).thenReturn((Object)new Exception("Enriched: ERROR"));
        Mockito.when((Object)this.enricherFactory.createHandler()).thenReturn((Object)exceptionEnricher);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, this.enricherFactory);
        ExtensionMessageSource messageSource = this.getNewExtensionMessageSourceInstance();
        ((Source)Mockito.doThrow((Throwable)new RuntimeException(ERROR_MESSAGE)).when((Object)this.source)).onStart(this.sourceCallback);
        Throwable t = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)messageSource).start());
        Assert.assertThat((Object)t.getMessage(), (Matcher)StringContains.containsString((String)"Enriched: ERROR"));
        messageSource.stop();
    }

    @Test
    public void workManagerDisposedIfSourceFailsToStart() throws Exception {
        this.initialise();
        this.start();
        final RuntimeException e = new RuntimeException();
        ((Source)Mockito.doThrow((Throwable)e).when((Object)this.source)).onStop();
        this.expectedException.expect((Matcher)new BaseMatcher<Throwable>(){

            public boolean matches(Object item) {
                Exception exception = (Exception)item;
                return exception.getCause() instanceof MuleException && exception.getCause().getCause() == e;
            }

            public void describeTo(Description description) {
                description.appendText("Exception was not wrapped as expected");
            }
        });
    }

    private ExtensionMessageSource getNewExtensionMessageSourceInstance() throws MuleException {
        ExtensionMessageSource messageSource = new ExtensionMessageSource(this.extensionModel, this.sourceModel, this.sourceAdapterFactory, this.configurationProvider, (RetryPolicyTemplate)this.retryPolicyTemplate, (CursorProviderFactory)this.cursorStreamProviderFactory, this.extensionManager);
        messageSource.setListener(this.messageProcessor);
        messageSource.setAnnotations(ExtensionMessageSourceTestCase.getAppleFlowComponentLocationAnnotations());
        muleContext.getInjector().inject((Object)messageSource);
        return messageSource;
    }

    private BaseMatcher<Throwable> exhaustedBecauseOf(Throwable cause) {
        return this.exhaustedBecauseOf((Matcher<Throwable>)CoreMatchers.sameInstance((Object)cause));
    }

    private SourceAdapter createSourceAdapter() {
        return new SourceAdapter(this.extensionModel, this.sourceModel, this.source, Optional.of(this.configurationInstance), (CursorProviderFactory)new NullCursorStreamProviderFactory((ByteBufferManager)new SimpleByteBufferManager(), this.streamingManager), this.sourceCallbackFactory, (ComponentLocation)Mockito.mock(ComponentLocation.class), (SourceConnectionManager)Mockito.mock(SourceConnectionManager.class), null, this.callbackParameters, null, (MessagingExceptionResolver)Mockito.mock(MessagingExceptionResolver.class));
    }

    private BaseMatcher<Throwable> exhaustedBecauseOf(final Matcher<Throwable> causeMatcher) {
        return new BaseMatcher<Throwable>(){

            public boolean matches(Object item) {
                Throwable exception = (Throwable)item;
                return causeMatcher.matches((Object)exception.getCause());
            }

            public void describeTo(Description description) {
                causeMatcher.describeTo(description);
            }
        };
    }

    @Test
    public void getMetadataKeyIdObjectValue() throws Exception {
        String person = "person";
        this.source = new DummySource("person");
        this.sourceAdapter = this.createSourceAdapter();
        Mockito.when((Object)this.sourceAdapterFactory.createAdapter((Optional)Matchers.any(), (SourceCallbackFactory)Matchers.any(), (ComponentLocation)Matchers.any(), (SourceConnectionManager)Matchers.any(), (MessagingExceptionResolver)Matchers.any())).thenReturn((Object)this.sourceAdapter);
        this.messageSource = this.getNewExtensionMessageSourceInstance();
        this.messageSource.initialise();
        this.messageSource.start();
        Object metadataKeyValue = this.messageSource.getParameterValueResolver().getParameterValue(METADATA_KEY);
        Assert.assertThat((Object)metadataKeyValue, (Matcher)CoreMatchers.is((Object)"person"));
    }

    private class DummySource
    extends Source {
        private String metadataKey;

        DummySource(String metadataKey) {
            this.metadataKey = metadataKey;
        }

        public void onStart(SourceCallback sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }
}

