/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBox;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.petstore.extension.PhoneNumber;
import org.springframework.core.ResolvableType;

@SmallTest
public class IntrospectionUtilsTestCase
extends AbstractMuleTestCase {
    public static final String OPERATION_RESULT = "operationResult";
    public static final String PAGING_PROVIDER = "pagingProvider";
    public static final String PAGING_PROVIDER_OPERATION_RESULT = "pagingProviderOperationResult";
    public static final String FOO = "foo";
    private List<FruitBasket> baskets;

    @Test
    public void getMethodReturnType() throws Exception {
        MetadataType metadataType = IntrospectionUtils.getMethodReturnType((Method)this.getMethod(FOO, new Class[0]), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        this.assertDictionary(metadataType, Apple.class);
    }

    @Test
    public void getOperationResultReturnType() throws Exception {
        this.assertReturnType(OPERATION_RESULT);
        this.assertAttributesType(OPERATION_RESULT);
    }

    @Test
    public void getPagingProviderReturnType() throws Exception {
        this.assertPagingProviderReturnType(PAGING_PROVIDER);
        this.assertVoidAttributesType(PAGING_PROVIDER);
    }

    @Test
    public void getPagingProviderOperationResultReturnType() throws Exception {
        this.assertPagingProviderReturnResultType(PAGING_PROVIDER_OPERATION_RESULT);
        this.assertVoidAttributesType(PAGING_PROVIDER_OPERATION_RESULT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullMethodReturnType() throws Exception {
        IntrospectionUtils.getMethodReturnType(null, (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
    }

    @Test
    public void getArgumentlessMethodArgumentTypes() throws Exception {
        MetadataType[] types = IntrospectionUtils.getMethodArgumentTypes((Method)this.getMethod(FOO, new Class[0]), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        junit.framework.Assert.assertNotNull((Object)types);
        junit.framework.Assert.assertEquals((int)0, (int)types.length);
    }

    @Test
    public void getMethodArgumentTypes() throws Exception {
        MetadataType[] types = IntrospectionUtils.getMethodArgumentTypes((Method)this.getMethod("bar", String.class, Long.class, Apple.class, Map.class), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        junit.framework.Assert.assertNotNull((Object)types);
        junit.framework.Assert.assertEquals((int)4, (int)types.length);
        this.assertType(types[0], String.class);
        this.assertType(types[1], Long.class);
        this.assertType(types[2], Apple.class);
        this.assertDictionary(types[3], Kiwi.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullMethodArgumentTypes() throws Exception {
        IntrospectionUtils.getMethodArgumentTypes(null, (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
    }

    @Test
    public void getFieldDataType() throws Exception {
        MetadataType type = IntrospectionUtils.getFieldMetadataType((Field)((Object)((Object)this)).getClass().getDeclaredField("baskets"), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        this.assertList(type, FruitBasket.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullFieldDataType() throws Exception {
        IntrospectionUtils.getFieldMetadataType(null, (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
    }

    @Test
    public void getEmptyExposedPojoFields() {
        Collection exposedFields = IntrospectionUtils.getExposedFields(FruitBasket.class);
        Assert.assertThat((Object)exposedFields, (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void getFieldsWithGettersOnly() {
        Set fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters(PhoneNumber.class);
        Assert.assertThat((Object)fieldsWithGetters.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void getWildCardFieldsDataTypes() {
        Set exposedFields = IntrospectionUtils.getFieldsWithGetters(FruitBox.class);
        junit.framework.Assert.assertNotNull((Object)exposedFields);
        junit.framework.Assert.assertEquals((int)6, (int)exposedFields.size());
        this.assertField("fruitLikeList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Fruit.class)), exposedFields);
        this.assertField("wildCardList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("rawList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("wildCardMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("rawMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("fruitLikeMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Fruit.class)), exposedFields);
    }

    @Test
    public void getDataTypeFromList() {
        Class<List> listClass = List.class;
        Class<Integer> integerClass = Integer.class;
        ArrayTypeBuilder arrayTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().with((TypeAnnotation)new ClassInformationAnnotation(listClass));
        arrayTypeBuilder.of().numberType().integer();
        CollectionDataType dataType = (CollectionDataType)IntrospectionUtils.toDataType((MetadataType)arrayTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(listClass)));
        Assert.assertThat((Object)dataType.getItemDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(integerClass)));
    }

    @Test
    public void getDataTypeFromMap() {
        Class<Date> dateClass = Date.class;
        Class<Map> mapClass = Map.class;
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class));
        objectTypeBuilder.openWith().objectType().id(dateClass.getName());
        MapDataType dataType = (MapDataType)IntrospectionUtils.toDataType((MetadataType)objectTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(mapClass)));
        Assert.assertThat((Object)dataType.getKeyDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
        Assert.assertThat((Object)dataType.getValueDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(dateClass)));
    }

    @Test
    public void getDataTypeFromObject() {
        Class<Object> objectClass = Object.class;
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(objectClass.getName());
        DataType dataType = IntrospectionUtils.toDataType((MetadataType)objectTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(objectClass)));
    }

    @Test
    public void getDataTypeFromString() {
        StringTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType();
        DataType dataType = IntrospectionUtils.toDataType((MetadataType)typeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
    }

    @Test
    public void getPagingProviderImplementationTypes() {
        ResolvableType pagingProvider = ResolvableType.forClass(TestPagingProvider.class);
        Pair pagingProviderTypes = IntrospectionUtils.getPagingProviderTypes((ResolvableType)pagingProvider);
        Assert.assertThat((Object)((ResolvableType)pagingProviderTypes.getFirst()).getRawClass(), (Matcher)CoreMatchers.equalTo(Object.class));
        Assert.assertThat((Object)((ResolvableType)pagingProviderTypes.getSecond()).getRawClass(), (Matcher)CoreMatchers.equalTo(Banana.class));
    }

    private void assertField(String name, MetadataType metadataType, Collection<Field> fields) {
        Field field = this.findField(name, fields);
        Assert.assertThat((Object)field, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)field.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat(field.getType(), (Matcher)CoreMatchers.equalTo((Object)JavaTypeUtils.getType((MetadataType)metadataType)));
    }

    private Field findField(String name, Collection<Field> fields) {
        return (Field)CollectionUtils.find(fields, f -> name.equals(((Field)f).getName()));
    }

    private void assertType(MetadataType type, Class<?> rawType) {
        Assert.assertThat((Object)rawType.isAssignableFrom(JavaTypeUtils.getType((MetadataType)type)), (Matcher)CoreMatchers.is((Object)true));
    }

    private Method getMethod(String methodName, Class<?> ... parameterTypes) throws Exception {
        return ((Object)((Object)this)).getClass().getMethod(methodName, parameterTypes);
    }

    private void assertDictionary(MetadataType metadataType, Class<?> valueType) {
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
        ObjectType dictionaryType = (ObjectType)metadataType;
        this.assertType((MetadataType)dictionaryType, Map.class);
        Assert.assertThat((Object)dictionaryType.getOpenRestriction().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertType((MetadataType)dictionaryType.getOpenRestriction().get(), valueType);
    }

    private void assertList(MetadataType metadataType, Class<?> listItemType) {
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        this.assertType(metadataType, List.class);
        MetadataType itemMetadataType = ((ArrayType)metadataType).getType();
        this.assertType(itemMetadataType, listItemType);
    }

    public Map<String, Apple> foo() {
        return new HashMap<String, Apple>();
    }

    public Result<String, Object> operationResult() {
        return null;
    }

    public PagingProvider<Object, String> pagingProvider() {
        return null;
    }

    public PagingProvider<Object, Result<String, Object>> pagingProviderOperationResult() {
        return null;
    }

    public int bar(String s, Long l, Apple apple, Map<Banana, Kiwi> fruits) {
        return Objects.hash(s, l, apple, fruits);
    }

    public List<FruitBasket> getBaskets() {
        return this.baskets;
    }

    public void setBaskets(List<FruitBasket> baskets) {
        this.baskets = baskets;
    }

    private void assertAttributesType(String method) throws Exception {
        MetadataType attributesType = IntrospectionUtils.getMethodReturnAttributesType((Method)this.getMethod(method, new Class[0]), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        Assert.assertThat((Object)attributesType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
        this.assertType(attributesType, Object.class);
    }

    private void assertVoidAttributesType(String method) throws Exception {
        MetadataType attributesType = IntrospectionUtils.getMethodReturnAttributesType((Method)this.getMethod(method, new Class[0]), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        Assert.assertThat((Object)attributesType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(VoidType.class)));
    }

    private void assertReturnType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((Method)this.getMethod(method, new Class[0]), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        this.assertType(returnType, String.class);
    }

    private void assertPagingProviderReturnType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((Method)this.getMethod(method, new Class[0]), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        Assert.assertThat((Object)((ArrayType)returnType).getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        this.assertType(((ArrayType)returnType).getType(), String.class);
    }

    private void assertPagingProviderReturnResultType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((Method)this.getMethod(method, new Class[0]), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        ExtensionsTestUtils.assertMessageType(((ArrayType)returnType).getType(), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
    }

    private class TestPagingProvider
    implements PagingProvider<Object, Banana> {
        private TestPagingProvider() {
        }

        public List<Banana> getPage(Object connection) {
            return null;
        }

        public Optional<Integer> getTotalResults(Object connection) {
            return null;
        }

        public void close(Object connection) throws MuleException {
        }
    }
}

