/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveOperationExecutorFactory;

final class ScopeModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String SCOPE = "Scope";
    private final Map<MethodElement, OperationDeclarer> operationDeclarers = new HashMap<MethodElement, OperationDeclarer>();

    ScopeModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareScope(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer ownerDeclarer, OperationContainerElement enclosingType, OperationElement scopeMethod, Optional<ExtensionParameter> configParameter, Optional<ExtensionParameter> connectionParameter) {
        HasOperationDeclarer actualDeclarer = (HasOperationDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)ownerDeclarer, configParameter, connectionParameter);
        OperationModelLoaderDelegate.checkDefinition(!configParameter.isPresent(), String.format("Scope '%s' requires a config, but that is not allowed, remove such parameter", scopeMethod.getName()));
        OperationModelLoaderDelegate.checkDefinition(!connectionParameter.isPresent(), String.format("Scope '%s' requires a connection, but that is not allowed, remove such parameter", scopeMethod.getName()));
        OperationModelLoaderDelegate.checkDefinition(ModelLoaderUtils.isNonBlocking(scopeMethod), String.format("Scope '%s' does not declare a '%s' parameter. One is required for all operations that receive and execute a Chain of other components", scopeMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        if (this.operationDeclarers.containsKey(scopeMethod)) {
            actualDeclarer.withOperation(this.operationDeclarers.get(scopeMethod));
            return;
        }
        OperationDeclarer scope = actualDeclarer.withOperation(scopeMethod.getAlias());
        scope.withModelProperty((ModelProperty)new ExtensionOperationDescriptorModelProperty(scopeMethod));
        Optional<Method> method = scopeMethod.getMethod();
        Optional<Class<?>> declaringClass = enclosingType.getDeclaringClass();
        if (method.isPresent() && declaringClass.isPresent()) {
            ((OperationDeclarer)scope.withModelProperty((ModelProperty)new ImplementingMethodModelProperty(method.get()))).withModelProperty((ModelProperty)new ComponentExecutorModelProperty(new ReflectiveOperationExecutorFactory(declaringClass.get(), method.get())));
        }
        this.processMimeType((HasModelProperties)scope, scopeMethod);
        OperationModelLoaderDelegate.processNonBlockingOperation(scope, scopeMethod, false);
        List processorChain = scopeMethod.getParameters().stream().filter(ModelLoaderUtils::isProcessorChain).collect(Collectors.toList());
        OperationModelLoaderDelegate.checkDefinition(processorChain.size() <= 1, String.format("Scope '%s' declares too many parameters of type '%s', only one input of this kind is supported.Offending parameters are: %s", scopeMethod.getAlias(), Chain.class.getSimpleName(), processorChain.stream().map(NamedObject::getName).collect(Collectors.toList())));
        this.declareParameters((ComponentDeclarer)scope, scopeMethod.getParameters(), ((OperationContainerElement)scopeMethod.getEnclosingType()).getParameters(), new ParameterDeclarationContext(SCOPE, (NamedDeclaration)scope.getDeclaration()));
        this.loader.addExceptionEnricher(scopeMethod, (HasModelProperties)scope);
        this.operationDeclarers.put(scopeMethod, scope);
    }
}

