/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.Interceptable;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ConfigurationObjectBuilderTestCase;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationInstanceFactoryTestCase
extends AbstractMuleTestCase {
    private static final String CONFIG_NAME = "config";
    private static final String ENCODING = "UTF-8";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationModel configurationModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private SourceModel sourceModel;
    @Mock
    private SourceCallbackModel sourceCallbackModel;
    @Mock
    private ComponentModel componentModel;
    @Mock
    private Interceptor interceptor1;
    @Mock
    private Interceptor interceptor2;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private CoreEvent event;
    @Mock
    private ConnectionProviderValueResolver<Object> connectionProviderValueResolver;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    private ResolverSet resolverSet;
    private ConfigurationInstanceFactory<ConfigurationObjectBuilderTestCase.TestConfig> factory;

    @Before
    public void before() throws Exception {
        ExtensionsTestUtils.mockConfigurationInstance(this.configurationModel, new ConfigurationObjectBuilderTestCase.TestConfig());
        ExtensionsTestUtils.mockInterceptors((EnrichableModel)this.configurationModel, Arrays.asList(() -> this.interceptor1, () -> this.interceptor2));
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.configurationModel.getSourceModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Arrays.asList(this.sourceModel));
        Mockito.when((Object)this.operationModel.getModelProperty(ConnectivityModelProperty.class)).thenReturn(Optional.of(new ConnectivityModelProperty(Banana.class)));
        Mockito.when((Object)this.sourceModel.getModelProperty(ConnectivityModelProperty.class)).thenReturn(Optional.of(new ConnectivityModelProperty(Banana.class)));
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        Mockito.when((Object)this.muleContext.getConfiguration().getDefaultEncoding()).thenReturn((Object)ENCODING);
        this.resolverSet = ConfigurationObjectBuilderTestCase.createResolverSet();
        this.factory = new ConfigurationInstanceFactory(this.extensionModel, this.configurationModel, this.resolverSet, this.muleContext);
    }

    @Test
    public void createFromEvent() throws Exception {
        ConfigurationInstance configurationInstance = this.factory.createConfiguration(CONFIG_NAME, this.event, this.connectionProviderValueResolver);
        this.assertConfiguration(configurationInstance);
    }

    @Test
    public void createFromResolverSetResult() throws Exception {
        ResolverSetResult result = ResolverSetResult.newBuilder().build();
        ConfigurationInstance configurationInstance = this.factory.createConfiguration(CONFIG_NAME, result, this.event, Optional.empty());
        this.assertConfiguration(configurationInstance);
        Assert.assertThat((Object)configurationInstance.getConnectionProvider().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertConfiguration(ConfigurationInstance configurationInstance) {
        Assert.assertThat((Object)configurationInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)configurationInstance.getName(), (Matcher)CoreMatchers.is((Object)CONFIG_NAME));
        Assert.assertThat((Object)configurationInstance.getModel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configurationModel)));
        Assert.assertThat((Object)configurationInstance.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConfigurationObjectBuilderTestCase.TestConfig.class)));
        Assert.assertThat((Object)configurationInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Interceptable.class)));
        Assert.assertThat((Object)((Interceptable)configurationInstance).getInterceptors(), (Matcher)Matchers.containsInAnyOrder((Object[])new Interceptor[]{this.interceptor1, this.interceptor2}));
    }

    public static class InvalidConnectionTypeProvider
    implements ConnectionProvider<Kiwi> {
        public Kiwi connect() throws ConnectionException {
            return new Kiwi();
        }

        public void disconnect(Kiwi kiwi) {
        }

        public ConnectionValidationResult validate(Kiwi kiwi) {
            return ConnectionValidationResult.success();
        }
    }

    public static class InvalidConfigTestConnectionProvider
    implements ConnectionProvider<Banana> {
        public Banana connect() throws ConnectionException {
            return new Banana();
        }

        public void disconnect(Banana banana) {
        }

        public ConnectionValidationResult validate(Banana banana) {
            return ConnectionValidationResult.success();
        }
    }
}

