/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.config.ImmutableExpirationPolicy;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.config.AbstractConfigurationProviderTestCase;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DynamicConfigurationProviderTestCase
extends AbstractConfigurationProviderTestCase<HeisenbergExtension> {
    private static final Class MODULE_CLASS = HeisenbergExtension.class;
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Mock
    private ResolverSet resolverSet;
    @Mock
    private OperationModel operationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResolverSetResult resolverSetResult;
    @Mock
    private ConnectionProviderResolver connectionProviderResolver;
    @Mock
    private ConnectionProvider connectionProvider;
    private ExpirationPolicy expirationPolicy;

    @Override
    @Before
    public void before() throws Exception {
        ExtensionsTestUtils.mockConfigurationInstance(this.configurationModel, MODULE_CLASS.newInstance());
        ExtensionsTestUtils.mockInterceptors((EnrichableModel)this.configurationModel, null);
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.configurationModel.getSourceModels()).thenReturn((Object)ImmutableList.of());
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel, ((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.configurationModel.getSourceModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.resolverSet.resolve(ValueResolvingContext.from((CoreEvent)this.event))).thenReturn((Object)this.resolverSetResult);
        Mockito.when((Object)this.resolverSetResult.asMap()).thenReturn(new HashMap());
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
        this.expirationPolicy = new ImmutableExpirationPolicy(5L, TimeUnit.MINUTES, (TimeSupplier)this.timeSupplier);
        Mockito.when((Object)this.connectionProviderResolver.getResolverSet()).thenReturn(Optional.empty());
        Mockito.when((Object)this.connectionProviderResolver.resolve((ValueResolvingContext)Matchers.any())).thenReturn(null);
        this.provider = new DynamicConfigurationProvider("config", this.extensionModel, this.configurationModel, this.resolverSet, (ConnectionProviderValueResolver)this.connectionProviderResolver, this.expirationPolicy, muleContext);
        super.before();
        this.provider.initialise();
        this.provider.start();
    }

    @After
    public void after() throws MuleException {
        this.provider.stop();
        this.provider.dispose();
    }

    @Test
    public void resolveCached() throws Exception {
        int count = 10;
        HeisenbergExtension config = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        for (int i = 1; i < 10; ++i) {
            Assert.assertThat((Object)this.provider.get((Event)this.event).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)config)));
        }
        ((ResolverSet)Mockito.verify((Object)this.resolverSet, (VerificationMode)Mockito.times((int)10))).resolve(ValueResolvingContext.from((CoreEvent)this.event));
    }

    @Test
    public void resolveCachedWithProviderParams() throws Exception {
        ResolverSet providerResolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        Mockito.when((Object)this.connectionProviderResolver.getResolverSet()).thenReturn(Optional.of(providerResolverSet));
        Mockito.when((Object)this.connectionProviderResolver.getObjectBuilder()).thenReturn(Optional.empty());
        Mockito.when((Object)providerResolverSet.resolve(ValueResolvingContext.from((CoreEvent)this.event))).thenReturn((Object)this.resolverSetResult);
        int count = 10;
        HeisenbergExtension config = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        for (int i = 1; i < 10; ++i) {
            Assert.assertThat((Object)this.provider.get((Event)this.event).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)config)));
        }
        ((ResolverSet)Mockito.verify((Object)providerResolverSet, (VerificationMode)Mockito.times((int)10))).resolve(ValueResolvingContext.from((CoreEvent)this.event));
        ((ResolverSet)Mockito.verify((Object)this.resolverSet, (VerificationMode)Mockito.times((int)10))).resolve(ValueResolvingContext.from((CoreEvent)this.event));
    }

    @Test
    public void resolveProviderParamsDifferentInstance() throws Exception {
        HeisenbergExtension config = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        ExtensionsTestUtils.mockConfigurationInstance(this.configurationModel, MODULE_CLASS.newInstance());
        ResolverSet providerResolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        Mockito.when((Object)this.connectionProviderResolver.getResolverSet()).thenReturn(Optional.of(providerResolverSet));
        Mockito.when((Object)this.connectionProviderResolver.getObjectBuilder()).thenReturn(Optional.empty());
        Mockito.when((Object)providerResolverSet.resolve(ValueResolvingContext.from((CoreEvent)this.event))).thenReturn(Mockito.mock(ResolverSetResult.class));
        Assert.assertThat((Object)this.provider.get((Event)this.event).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)config))));
        ((ResolverSet)Mockito.verify((Object)this.resolverSet, (VerificationMode)Mockito.times((int)2))).resolve(ValueResolvingContext.from((CoreEvent)this.event));
        ((ResolverSet)Mockito.verify((Object)providerResolverSet, (VerificationMode)Mockito.times((int)1))).resolve(ValueResolvingContext.from((CoreEvent)this.event));
        ((ConnectionProviderResolver)Mockito.verify((Object)this.connectionProviderResolver, (VerificationMode)Mockito.times((int)2))).resolve(ValueResolvingContext.from((CoreEvent)this.event));
    }

    @Test
    public void resolveDifferentInstances() throws Exception {
        HeisenbergExtension instance1 = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        HeisenbergExtension instance2 = this.makeAlternateInstance();
        Assert.assertThat((Object)instance2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)instance1))));
    }

    @Test
    public void getExpired() throws Exception {
        HeisenbergExtension instance1 = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        HeisenbergExtension instance2 = this.makeAlternateInstance();
        DynamicConfigurationProvider provider = (DynamicConfigurationProvider)this.provider;
        this.timeSupplier.move(1L, TimeUnit.MINUTES);
        List expired = provider.getExpired();
        Assert.assertThat((Object)expired.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        this.timeSupplier.move(10L, TimeUnit.MINUTES);
        expired = provider.getExpired();
        Assert.assertThat((Object)expired.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        List configs = (List)expired.stream().map(config -> config.getValue()).collect(Collectors.toImmutableList());
        Assert.assertThat((Object)configs, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new Object[]{instance1, instance2}));
    }

    private HeisenbergExtension makeAlternateInstance() throws Exception {
        ResolverSetResult alternateResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)alternateResult.asMap()).thenReturn(new HashMap());
        ExtensionsTestUtils.mockConfigurationInstance(this.configurationModel, MODULE_CLASS.newInstance());
        Mockito.when((Object)this.resolverSet.resolve(ValueResolvingContext.from((CoreEvent)this.event))).thenReturn((Object)alternateResult);
        return (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
    }

    @Test
    public void resolveDynamicConfigWithEquivalentEvent() throws Exception {
        this.assertSameInstancesResolved();
    }

    @Test
    public void resolveDynamicConfigWithDifferentEvent() throws Exception {
        ConfigurationInstance config1 = this.provider.get((Event)this.event);
        Mockito.when((Object)this.resolverSet.resolve(ValueResolvingContext.from((CoreEvent)this.event))).thenReturn(Mockito.mock(ResolverSetResult.class));
        ConfigurationInstance config2 = this.provider.get((Event)this.event);
        Assert.assertThat((Object)config1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)config2))));
    }

    @Test
    public void configFailsOnInitialize() throws Exception {
        Lifecycle connProvider = (Lifecycle)Mockito.mock(Lifecycle.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{ConnectionProvider.class}));
        String expectedExceptionMessage = "Init failed!";
        ((Lifecycle)Mockito.doThrow((Throwable)new RuntimeException("Init failed!")).when((Object)connProvider)).initialise();
        Mockito.when((Object)this.connectionProviderResolver.resolve((ValueResolvingContext)Matchers.any())).thenReturn((Object)new Pair((Object)connProvider, Mockito.mock(ResolverSetResult.class)));
        this.expected.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.is((Object)(InitialisationException.class.getName() + ": " + "Init failed!"))));
        try {
            this.provider.get((Event)this.event);
        }
        finally {
            ((Lifecycle)Mockito.verify((Object)connProvider)).initialise();
            ((Lifecycle)Mockito.verify((Object)connProvider, (VerificationMode)Mockito.never())).start();
            ((Lifecycle)Mockito.verify((Object)connProvider, (VerificationMode)Mockito.never())).stop();
            ((Lifecycle)Mockito.verify((Object)connProvider)).dispose();
        }
    }

    @Test
    public void configFailsOnStart() throws Exception {
        Lifecycle connProvider = (Lifecycle)Mockito.mock(Lifecycle.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{ConnectionProvider.class}));
        RuntimeException toThrow = new RuntimeException("Start failed!");
        ((Lifecycle)Mockito.doThrow((Throwable)toThrow).when((Object)connProvider)).start();
        Mockito.when((Object)this.connectionProviderResolver.resolve((ValueResolvingContext)Matchers.any())).thenReturn((Object)new Pair((Object)connProvider, (Object)this.resolverSetResult));
        this.expected.expectCause(CoreMatchers.sameInstance((Object)toThrow));
        try {
            this.provider.get((Event)this.event);
        }
        finally {
            ((Lifecycle)Mockito.verify((Object)connProvider)).initialise();
            ((Lifecycle)Mockito.verify((Object)connProvider)).start();
            ((Lifecycle)Mockito.verify((Object)connProvider)).stop();
            ((Lifecycle)Mockito.verify((Object)connProvider)).dispose();
        }
    }
}

