/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.PropertyElement;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FieldWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.springframework.core.ResolvableType;

public class TypeWrapper
implements org.mule.runtime.module.extension.api.loader.java.type.Type {
    private final Type type;
    final Class<?> aClass;
    private List<TypeGeneric> generics = Collections.emptyList();
    private ResolvableType[] resolvableTypeGenerics = new ResolvableType[0];
    ClassTypeLoader typeLoader;

    public TypeWrapper(Class<?> aClass, ClassTypeLoader typeLoader) {
        this.aClass = aClass;
        this.type = aClass;
        this.typeLoader = typeLoader;
    }

    public TypeWrapper(ResolvableType resolvableType, ClassTypeLoader typeLoader) {
        this.aClass = resolvableType.getRawClass();
        this.type = resolvableType.getType();
        this.generics = new ArrayList<TypeGeneric>();
        this.typeLoader = typeLoader;
        if (!(this.type instanceof Class)) {
            for (ResolvableType type : this.resolvableTypeGenerics = resolvableType.getGenerics()) {
                TypeWrapper concreteType = type == resolvableType ? this : new TypeWrapper(type, typeLoader);
                this.generics.add(new TypeGeneric(concreteType, concreteType.getGenerics()));
            }
        }
    }

    public TypeWrapper(Type type, ClassTypeLoader typeLoader) {
        this(ResolvableType.forType((Type)type), typeLoader);
    }

    @Override
    public String getName() {
        return this.aClass.getSimpleName();
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.aClass.getAnnotation(annotationClass));
    }

    @Override
    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher<A>(annotationClass, this.aClass, this.typeLoader)) : Optional.empty();
    }

    @Override
    public List<FieldElement> getFields() {
        return IntrospectionUtils.getFields(this.aClass).stream().map(field -> new FieldWrapper((Field)field, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public List<PropertyElement> getProperties() {
        return IntrospectionUtils.getPropertyDescriptors(this.aClass).stream().map(p -> {
            PropertyElement.Accessibility accessibility = p.getReadMethod() != null && p.getWriteMethod() != null ? PropertyElement.Accessibility.READ_WRITE : (p.getReadMethod() != null && p.getWriteMethod() == null ? PropertyElement.Accessibility.READ_ONLY : PropertyElement.Accessibility.WRITE_ONLY);
            return PropertyElement.builder().type(new TypeWrapper(p.getPropertyType(), this.typeLoader)).name(p.getName()).accessibility(accessibility).build();
        }).collect(Collectors.toList());
    }

    @Override
    public List<FieldElement> getAnnotatedFields(Class<? extends Annotation> ... annotations) {
        return this.getFields().stream().filter(field -> Stream.of(annotations).anyMatch(field::isAnnotatedWith)).collect(Collectors.toList());
    }

    @Override
    public Optional<Class<?>> getDeclaringClass() {
        return Optional.ofNullable(this.aClass);
    }

    @Override
    public boolean isAssignableFrom(Class<?> clazz) {
        return this.aClass != null && this.aClass.isAssignableFrom(clazz);
    }

    @Override
    public boolean isAssignableFrom(org.mule.runtime.module.extension.api.loader.java.type.Type type) {
        if (type instanceof TypeWrapper) {
            return this.aClass.isAssignableFrom(type.getDeclaringClass().get());
        }
        return type.isAssignableTo(this);
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return this.aClass != null && clazz.isAssignableFrom(this.aClass);
    }

    @Override
    public boolean isAssignableTo(org.mule.runtime.module.extension.api.loader.java.type.Type type) {
        return type.isAssignableFrom(this);
    }

    @Override
    public boolean isSameType(org.mule.runtime.module.extension.api.loader.java.type.Type type) {
        if (type instanceof TypeWrapper) {
            Class<?> aClass = ((TypeWrapper)type).aClass;
            return this.isSameType(aClass);
        }
        return false;
    }

    @Override
    public boolean isSameType(Class<?> clazz) {
        return this.aClass.equals(clazz);
    }

    @Override
    public boolean isInstantiable() {
        return IntrospectionUtils.isInstantiable(this.aClass);
    }

    @Override
    public String getTypeName() {
        return this.aClass.getTypeName();
    }

    @Override
    public ClassInformationAnnotation getClassInformation() {
        return new ClassInformationAnnotation(this.aClass, Stream.of(this.resolvableTypeGenerics).map(ResolvableType::getType).collect(Collectors.toList()));
    }

    @Override
    public boolean isAnyType() {
        Type[] bounds;
        if (this.type instanceof TypeVariable && (bounds = ((TypeVariable)this.type).getBounds()).length > 0) {
            return bounds[0].equals(Object.class);
        }
        return this.type instanceof WildcardType && this.type.getTypeName().equals("?");
    }

    @Override
    public List<TypeGeneric> getGenerics() {
        return this.generics;
    }

    @Override
    public MetadataType asMetadataType() {
        return this.typeLoader.load(this.type);
    }

    @Override
    public List<org.mule.runtime.module.extension.api.loader.java.type.Type> getInterfaceGenerics(Class interfaceClass) {
        return IntrospectionUtils.getInterfaceGenerics(this.type, interfaceClass).stream().map(e -> new TypeWrapper((ResolvableType)e, this.typeLoader)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeWrapper that = (TypeWrapper)o;
        return new EqualsBuilder().append((Object)this.type, (Object)that.type).append(this.aClass, that.aClass).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.type).append(this.aClass).toHashCode();
    }

    @Override
    public Optional<TypeElement> getElement() {
        return Optional.empty();
    }
}

