/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.ComponentLocationProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.processor.ParametersResolverProcessor;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.LazyExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.InterceptorsExecutionResult;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.VoidReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ComponentMessageProcessor<T extends ComponentModel>
extends ExtensionComponent<T>
implements Processor,
ParametersResolverProcessor<T>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessor.class);
    static final String INVALID_TARGET_MESSAGE = "Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s";
    protected final ExtensionModel extensionModel;
    protected final ResolverSet resolverSet;
    protected final String target;
    protected final String targetValue;
    protected final RetryPolicyTemplate retryPolicyTemplate;
    protected ExecutionMediator executionMediator;
    protected ComponentExecutor componentExecutor;
    protected PolicyManager policyManager;
    protected ReturnDelegate returnDelegate;
    private boolean initialised = false;

    public ComponentMessageProcessor(ExtensionModel extensionModel, T componentModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager) {
        super(extensionModel, componentModel, configurationProvider, cursorProviderFactory, extensionManager);
        this.extensionModel = extensionModel;
        this.resolverSet = resolverSet;
        this.target = target;
        this.targetValue = targetValue;
        this.policyManager = policyManager;
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).flatMap(Exceptions.checkedFunction(event -> {
            OperationExecutionFunction operationExecutionFunction;
            Optional configuration;
            if (((InternalEvent)event).getInternalParameters().containsKey("core:interceptionResolvedContext")) {
                PrecalculatedExecutionContextAdapter<T> operationContext = this.getPrecalculatedContext((CoreEvent)event);
                configuration = operationContext.getConfiguration();
                operationExecutionFunction = (parameters, operationEvent) -> this.doProcess(operationEvent, operationContext);
            } else {
                configuration = this.getConfiguration((CoreEvent)event);
                operationExecutionFunction = (parameters, operationEvent) -> {
                    ExecutionContextAdapter<T> operationContext;
                    try {
                        operationContext = this.createExecutionContext(configuration, parameters, operationEvent);
                    }
                    catch (MuleException e2) {
                        return Flux.error((Throwable)e2);
                    }
                    return this.doProcess(operationEvent, operationContext).onErrorMap(e -> !(e instanceof MessagingException), e -> new MessagingException(event, e, (Component)this));
                };
            }
            if (this.getLocation() != null) {
                String resolveProcessorRepresentation = ComponentLocationProvider.resolveProcessorRepresentation((String)this.muleContext.getConfiguration().getId(), (String)this.getLocation().getLocation(), (Object)((Object)this));
                ((DefaultFlowCallStack)event.getFlowCallStack()).setCurrentProcessorPath(resolveProcessorRepresentation);
                return this.policyManager.createOperationPolicy((Component)this, event, this.getResolutionResult((CoreEvent)event, configuration), operationExecutionFunction).process(event);
            }
            return operationExecutionFunction.execute(this.getResolutionResult((CoreEvent)event, configuration), event);
        }));
    }

    private PrecalculatedExecutionContextAdapter<T> getPrecalculatedContext(CoreEvent event) {
        return (PrecalculatedExecutionContextAdapter)((InternalEvent)event).getInternalParameters().get("core:interceptionResolvedContext");
    }

    protected Mono<CoreEvent> doProcess(CoreEvent event, ExecutionContextAdapter<T> operationContext) {
        return this.executeOperation(operationContext).map(value -> this.asReturnValue(operationContext, value)).switchIfEmpty(Mono.fromCallable(() -> this.asReturnValue(operationContext, null))).onErrorMap(Exceptions::unwrap);
    }

    private CoreEvent asReturnValue(ExecutionContextAdapter<T> operationContext, Object value) {
        if (value instanceof CoreEvent) {
            return (CoreEvent)value;
        }
        return this.returnDelegate.asReturnValue(value, operationContext);
    }

    private Mono<Object> executeOperation(ExecutionContextAdapter operationContext) {
        return Mono.from(this.executionMediator.execute(this.componentExecutor, operationContext));
    }

    private ExecutionContextAdapter<T> createExecutionContext(Optional<ConfigurationInstance> configuration, Map<String, Object> resolvedParameters, CoreEvent event) throws MuleException {
        return new DefaultExecutionContext<ComponentModel>(this.extensionModel, configuration, resolvedParameters, this.componentModel, event, this.getCursorProviderFactory(), this.streamingManager, (Component)this, this.retryPolicyTemplate, this.muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        if (!this.initialised) {
            this.returnDelegate = this.createReturnDelegate();
            LifecycleUtils.initialiseIfNeeded((Object)this.resolverSet, (MuleContext)this.muleContext);
            this.componentExecutor = this.createComponentExecutor();
            this.executionMediator = this.createExecutionMediator();
            LifecycleUtils.initialiseIfNeeded((Object)this.componentExecutor, (boolean)true, (MuleContext)this.muleContext);
            this.initialised = true;
        }
    }

    private ComponentExecutor<T> createComponentExecutor() {
        HashMap params = new HashMap();
        LazyValue staticConfiguration = new LazyValue(this::getStaticConfiguration);
        LazyValue resolvingContext = new LazyValue(() -> {
            CoreEvent initialiserEvent = null;
            try {
                initialiserEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent();
                ValueResolvingContext valueResolvingContext = ValueResolvingContext.from(initialiserEvent, (Optional)staticConfiguration.get());
                return valueResolvingContext;
            }
            finally {
                if (initialiserEvent != null) {
                    ((BaseEventContext)initialiserEvent.getContext()).success();
                }
            }
        });
        this.componentModel.getParameterGroupModels().stream().forEach(group -> {
            if (group.getName().equals("General")) {
                group.getParameterModels().stream().filter(p -> p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent()).forEach(p -> {
                    ValueResolver<?> resolver = this.resolverSet.getResolvers().get(p.getName());
                    if (resolver != null) {
                        try {
                            params.put(IntrospectionUtils.getMemberName(p), ResolverUtils.resolveValue(resolver, (ValueResolvingContext)resolvingContext.get()));
                        }
                        catch (MuleException e) {
                            throw new MuleRuntimeException((Throwable)e);
                        }
                    }
                });
            } else {
                ParameterGroupDescriptor groupDescriptor = group.getModelProperty(ParameterGroupModelProperty.class).map(g -> g.getDescriptor()).orElse(null);
                if (groupDescriptor == null) {
                    return;
                }
                List<ParameterModel> fieldParameters = this.getGroupsOfFieldParameters((ParameterGroupModel)group);
                if (fieldParameters.isEmpty()) {
                    return;
                }
                ObjectBuilder groupBuilder = this.createFieldParameterGroupBuilder(groupDescriptor, fieldParameters);
                try {
                    params.put(((Field)groupDescriptor.getContainer()).getName(), groupBuilder.build((ValueResolvingContext)resolvingContext.get()));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
        });
        return MuleExtensionUtils.getOperationExecutorFactory(this.componentModel).createExecutor(this.componentModel, params);
    }

    private ObjectBuilder createFieldParameterGroupBuilder(ParameterGroupDescriptor groupDescriptor, List<ParameterModel> fieldParameters) {
        DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(groupDescriptor.getType().getDeclaringClass().get());
        fieldParameters.forEach(p -> {
            ValueResolver<?> resolver = this.resolverSet.getResolvers().get(p.getName());
            if (resolver != null) {
                groupBuilder.addPropertyResolver(IntrospectionUtils.getMemberName(p), resolver);
            }
        });
        return groupBuilder;
    }

    private List<ParameterModel> getGroupsOfFieldParameters(ParameterGroupModel group) {
        return group.getParameterModels().stream().filter(p -> p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    protected ReturnDelegate createReturnDelegate() {
        if (IntrospectionUtils.isVoid(this.componentModel)) {
            return VoidReturnDelegate.INSTANCE;
        }
        return !this.isTargetPresent() ? this.getValueReturnDelegate() : this.getTargetReturnDelegate();
    }

    protected TargetReturnDelegate getTargetReturnDelegate() {
        return new TargetReturnDelegate(this.target, this.targetValue, this.componentModel, this.cursorProviderFactory, this.muleContext);
    }

    protected ValueReturnDelegate getValueReturnDelegate() {
        return new ValueReturnDelegate(this.componentModel, this.cursorProviderFactory, this.muleContext);
    }

    protected boolean isTargetPresent() {
        if (StringUtils.isBlank((CharSequence)this.target)) {
            return false;
        }
        if (this.muleContext.getExpressionManager().isExpression(this.target)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.componentModel.getName(), "an expression", "target"));
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.targetValue)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.componentModel.getName(), "something that is not an expression", "targetValue"));
        }
        return true;
    }

    protected Optional<String> getTarget() {
        return this.isTargetPresent() ? Optional.of(this.target) : Optional.empty();
    }

    @Override
    public void doStart() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.componentExecutor);
    }

    @Override
    public void doStop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.componentExecutor);
    }

    @Override
    public void doDispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.componentExecutor, (Logger)LOGGER);
        this.initialised = false;
    }

    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator<ComponentModel>(this.extensionModel, this.componentModel, this.connectionManager, this.muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[0]);
    }

    @Override
    protected abstract void validateOperationConfiguration(ConfigurationProvider var1);

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        CoreEvent event = null;
        try {
            event = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
            OperationParameterValueResolver<ComponentModel> operationParameterValueResolver = new OperationParameterValueResolver<ComponentModel>(new LazyExecutionContext<ComponentModel>(this.resolverSet, this.componentModel, this.extensionModel, ValueResolvingContext.from(event)));
            return operationParameterValueResolver;
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }
    }

    public abstract ReactiveProcessor.ProcessingType getProcessingType();

    public void resolveParameters(CoreEvent.Builder eventBuilder, BiConsumer<Map<String, LazyValue<Object>>, ExecutionContext> afterConfigurer) throws MuleException {
        if (this.componentExecutor instanceof OperationArgumentResolverFactory) {
            List<Interceptor> interceptors;
            DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
            PrecalculatedExecutionContextAdapter<T> executionContext = new PrecalculatedExecutionContextAdapter<T>(this.createExecutionContext(eventBuilder.build()), this.componentExecutor);
            InterceptorsExecutionResult beforeExecutionResult = mediator.before(executionContext, interceptors = mediator.collectInterceptors(executionContext.getConfiguration(), executionContext.getOperationExecutor()));
            if (beforeExecutionResult.isOk()) {
                Map<String, Object> resolvedArguments = ((OperationArgumentResolverFactory)this.componentExecutor).createArgumentResolver(this.componentModel).apply(executionContext);
                afterConfigurer.accept(resolvedArguments, executionContext);
                executionContext.changeEvent(eventBuilder.build());
            } else {
                this.disposeResolvedParameters(executionContext, interceptors);
                throw new DefaultMuleException("Interception execution for operation not ok", beforeExecutionResult.getThrowable());
            }
        }
    }

    public void disposeResolvedParameters(ExecutionContext<T> executionContext) {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        List<Interceptor> interceptors = mediator.collectInterceptors(executionContext.getConfiguration(), executionContext instanceof PrecalculatedExecutionContextAdapter ? ((PrecalculatedExecutionContextAdapter)executionContext).getOperationExecutor() : this.componentExecutor);
        this.disposeResolvedParameters(executionContext, interceptors);
    }

    private void disposeResolvedParameters(ExecutionContext<T> executionContext, List<Interceptor> interceptors) {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        mediator.after(executionContext, null, interceptors);
    }

    private ExecutionContextAdapter<T> createExecutionContext(CoreEvent event) throws MuleException {
        Optional<ConfigurationInstance> configuration = this.getConfiguration(event);
        return this.createExecutionContext(configuration, this.getResolutionResult(event, configuration), event);
    }

    private Map<String, Object> getResolutionResult(CoreEvent event, Optional<ConfigurationInstance> configuration) throws MuleException {
        return this.resolverSet.resolve(ValueResolvingContext.from(event, configuration)).asMap();
    }
}

