/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.ClusterSupportEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class ClusterSupportEnricherTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SourceDeclaration sourceDeclaration;
    @Mock
    private ParameterGroupDeclaration parameterGroup;
    private ClusterSupportEnricher enricher = new ClusterSupportEnricher();
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getMessageSources()).thenReturn(Arrays.asList(this.sourceDeclaration));
        Mockito.when((Object)this.sourceDeclaration.getParameterGroup("General")).thenReturn((Object)this.parameterGroup);
        Mockito.when((Object)this.sourceDeclaration.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceDeclaration.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceDeclaration.getBackPressureCallback()).thenReturn(Optional.empty());
    }

    @Test
    public void defaultBehavior() {
        this.setSourceClass(TestSource.class);
        this.assertEnrichment(false, true, false);
    }

    @Test
    public void clusterNotSupported() {
        this.setSourceClass(NonClusteredSource.class);
        this.assertEnrichment(true, false, false);
    }

    @Test
    public void defaultAllNodes() {
        this.setSourceClass(AllNodesSource.class);
        this.assertEnrichment(false, true, false);
    }

    @Test
    public void defaultPrimaryNodeOnly() {
        this.setSourceClass(PrimaryNodeSource.class);
        this.assertEnrichment(false, true, true);
    }

    private void assertEnrichment(boolean runsOnPrimaryNodeOnly, boolean parameterAdded, boolean defaultParameterValue) {
        this.enricher.enrich(this.extensionLoadingContext);
        ((SourceDeclaration)Mockito.verify((Object)this.sourceDeclaration)).setRunsOnPrimaryNodeOnly(runsOnPrimaryNodeOnly);
        if (parameterAdded) {
            ArgumentCaptor captor = ArgumentCaptor.forClass(ParameterDeclaration.class);
            ((ParameterGroupDeclaration)Mockito.verify((Object)this.parameterGroup)).addParameter((ParameterDeclaration)captor.capture());
            ParameterDeclaration parameter = (ParameterDeclaration)captor.getValue();
            Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.equalTo((Object)"primaryNodeOnly"));
            Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Object)defaultParameterValue));
        } else {
            ((ParameterGroupDeclaration)Mockito.verify((Object)this.parameterGroup, (VerificationMode)Mockito.never())).addParameter((ParameterDeclaration)Matchers.any());
        }
    }

    private void setSourceClass(Class<? extends Source> sourceClass) {
        ExtensionTypeDescriptorModelProperty property = new ExtensionTypeDescriptorModelProperty((Type)new TypeWrapper(sourceClass, this.typeLoader));
        Mockito.when((Object)this.sourceDeclaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class)).thenReturn(Optional.of(property));
    }

    @ClusterSupport(value=SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY)
    public static class PrimaryNodeSource
    extends TestSource {
    }

    @ClusterSupport(value=SourceClusterSupport.DEFAULT_ALL_NODES)
    public static class AllNodesSource
    extends TestSource {
    }

    @ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
    public static class NonClusteredSource
    extends TestSource {
    }

    public static class TestSource
    extends Source {
        public void onStart(SourceCallback sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }
}

