/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.InterceptorFactory;
import org.mule.runtime.module.extension.internal.loader.enricher.ConnectionDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.InterceptorsModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionInterceptor;
import org.mule.runtime.module.extension.internal.runtime.streaming.CursorResetInterceptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final String CONNECTED_OPERATION = "connectedOperation";
    private static final String NOT_CONNECTED_OPERATION = "notConnectedOperation";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    private OperationDeclaration connectedOperation;
    private OperationDeclaration notConnectedOperation;
    private DeclarationEnricher enricher = new ConnectionDeclarationEnricher();

    @Before
    public void before() throws Exception {
        this.connectedOperation = (OperationDeclaration)Mockito.spy((Object)((OperationDeclarer)new ExtensionDeclarer().withOperation(CONNECTED_OPERATION).requiresConnection(true)).getDeclaration());
        this.notConnectedOperation = (OperationDeclaration)Mockito.spy((Object)((OperationDeclarer)new ExtensionDeclarer().withOperation(NOT_CONNECTED_OPERATION).requiresConnection(false)).getDeclaration());
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Arrays.asList(this.connectedOperation, this.notConnectedOperation));
    }

    @Test
    public void enrichConnectedOperation() throws Exception {
        this.enricher.enrich(this.extensionLoadingContext);
        ((OperationDeclaration)Mockito.verify((Object)this.connectedOperation)).addModelProperty((ModelProperty)org.mockito.Matchers.isA(InterceptorsModelProperty.class));
        InterceptorsModelProperty interceptors = (InterceptorsModelProperty)this.connectedOperation.getModelProperty(InterceptorsModelProperty.class).get();
        Assert.assertThat((Object)interceptors.getInterceptorFactories(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((InterceptorFactory)interceptors.getInterceptorFactories().get(0)).createInterceptor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConnectionInterceptor.class)));
        Assert.assertThat((Object)((InterceptorFactory)interceptors.getInterceptorFactories().get(1)).createInterceptor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CursorResetInterceptor.class)));
    }

    @Test
    public void enrichOnlyOnceWhenFlyweight() throws Exception {
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Arrays.asList(this.connectedOperation, this.connectedOperation, this.notConnectedOperation));
        this.enricher.enrich(this.extensionLoadingContext);
        ((OperationDeclaration)Mockito.verify((Object)this.connectedOperation, (VerificationMode)Mockito.times((int)1))).addModelProperty((ModelProperty)org.mockito.Matchers.isA(InterceptorsModelProperty.class));
    }

    @Test
    public void skipNotConnectedOperation() throws Exception {
        this.enricher.enrich(this.extensionLoadingContext);
        ((OperationDeclaration)Mockito.verify((Object)this.notConnectedOperation, (VerificationMode)Mockito.never())).addModelProperty((ModelProperty)org.mockito.Matchers.isA(InterceptorsModelProperty.class));
    }
}

