/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.validation.InjectedFieldsModelValidator;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class InjectedFieldsModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private SourceModel sourceModel;
    @Mock
    private ConfigurationModel configurationModel;
    @Mock
    private ExtensionTypeDescriptorModelProperty modelProperty;
    @Mock
    private Type type;
    private InjectedFieldsModelValidator validator = new InjectedFieldsModelValidator();

    @Before
    public void before() {
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel, ((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"dummyExtension");
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel, this.sourceModel});
        Mockito.when((Object)this.extensionModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class)).thenReturn(Optional.of(this.modelProperty));
        Mockito.when((Object)this.modelProperty.getType()).thenReturn((Object)this.type);
        Mockito.when((Object)this.type.getDeclaringClass()).thenReturn(Optional.of(((Object)((Object)this)).getClass()));
    }

    @Test
    public void singleEncodingOperationArgument() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        this.withMethod(this.operationModel, "singleEncoding");
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void encodingOperationArgumentWrongType() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        this.withMethod(this.operationModel, "encodingWrongType");
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void repeatedEncodingOperationArgument() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        this.withMethod(this.operationModel, "repeatedEncoding");
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void repeatedEncodingOperationArgumentObjectFields() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        this.withMethod(this.operationModel, "argumentWithRepeatedEncodingFields");
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(RepeatedEncoding.class));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, parameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void repeatedEncodingPojoField() {
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Arrays.asList(this.sourceModel));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.empty());
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(RepeatedEncoding.class));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.sourceModel, parameterModel);
        ExtensionsTestUtils.mockImplementingType((EnrichableModel)this.sourceModel, SourceRepeatedEncoding.class);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void repeatedEncodingSourceField() {
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Arrays.asList(this.sourceModel));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.empty());
        ExtensionsTestUtils.mockImplementingType((EnrichableModel)this.sourceModel, SourceRepeatedEncoding.class);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void repeatedEncodingConfigField() {
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        ExtensionsTestUtils.mockImplementingType((EnrichableModel)this.configurationModel, ConfigRepeatedEncoding.class);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void repeatedRefNameConfigField() {
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        ExtensionsTestUtils.mockImplementingType((EnrichableModel)this.configurationModel, ConfigRepeatedRefName.class);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void encodingConfigFieldWrongType() {
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        ExtensionsTestUtils.mockImplementingType((EnrichableModel)this.configurationModel, ConfigEncodingWrongType.class);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    private void withMethod(OperationModel operationModel, String operationName) {
        Mockito.when((Object)operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(IntrospectionUtils.getApiMethods(Operations.class).stream().filter(m -> m.getName().equals(operationName)).findFirst().map(operationMethod -> new ExtensionOperationDescriptorModelProperty((MethodElement)new OperationWrapper(operationMethod, ExtensionsTestUtils.TYPE_LOADER))));
    }

    public static class ConfigRepeatedRefName {
        @RefName
        private String refName1;
        @RefName
        private String refName2;
    }

    public static class ConfigEncodingWrongType {
        @DefaultEncoding
        private Boolean encoding1;
    }

    public static class ConfigRepeatedEncoding {
        @DefaultEncoding
        private String encoding1;
        @DefaultEncoding
        private String encoding2;
    }

    public static class SourceRepeatedEncoding
    extends Source<String, Object> {
        @DefaultEncoding
        private String encoding1;
        @DefaultEncoding
        private String encoding2;

        public void onStart(SourceCallback sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public static class Operations {
        public void repeatedEncoding(@DefaultEncoding String encoding1, @DefaultEncoding String encoding2) {
        }

        public void argumentWithRepeatedEncodingFields(RepeatedEncoding encoding) {
        }

        public void singleEncoding(@DefaultEncoding String encoding1) {
        }

        public void encodingWrongType(@DefaultEncoding Integer encoding1) {
        }
    }

    public static class RepeatedEncoding {
        @Parameter
        @org.mule.runtime.extension.api.annotation.param.Optional
        public String someParameter;
        @DefaultEncoding
        private String encoding1;
        @DefaultEncoding
        private String encoding2;
    }
}

