/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.validation.ValueProviderModelValidator;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ValueProviderModelValidatorTestCase {
    private final JavaTypeLoader loader = new JavaTypeLoader(this.getClass().getClassLoader());
    private final MetadataType STRING_TYPE = this.loader.load(String.class);
    private final MetadataType NUMBER_TYPE = this.loader.load(Integer.class);
    private ValueProviderModelValidator valueProviderModelValidator;
    private ProblemsReporter problemsReporter;
    @Mock
    ExtensionModel extensionModel;
    @Mock
    OperationModel operationModel;
    @Mock
    ParameterModel operationParameter;
    @Mock
    ParameterModel configrationParameter;
    @Mock
    ConfigurationModel configurationModel;
    @Mock
    ParameterGroupModel parameterGroupModel;
    @Mock
    ParameterGroupModel configurationParameterGroupModel;
    private ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder operationParameterBuilder;
    private ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder configrationParameterBuilder;

    @Before
    public void setUp() {
        this.valueProviderModelValidator = new ValueProviderModelValidator();
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
        this.operationParameterBuilder = ValueProviderFactoryModelProperty.builder(SomeValueProvider.class);
        this.configrationParameterBuilder = ValueProviderFactoryModelProperty.builder(SomeValueProvider.class);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        Mockito.when((Object)this.configurationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.configrationParameter));
        Mockito.when((Object)this.configurationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.configurationParameterGroupModel));
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)"SomeConfig");
        Mockito.when((Object)this.configurationParameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.configrationParameter));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.operationParameter));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"superOperation");
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.operationParameter));
        Mockito.when((Object)this.operationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        this.mockParameter(this.configrationParameter, this.configrationParameterBuilder);
        this.mockParameter(this.operationParameter, this.operationParameterBuilder);
    }

    @Test
    public void valueProviderShouldBeInstantiable() {
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder = ValueProviderFactoryModelProperty.builder(NonInstantiableProvider.class);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(builder.build()));
        this.validate();
        this.assertProblems("The Value Provider [NonInstantiableProvider] is not instantiable but it should");
    }

    @Test
    public void parameterShouldExist() {
        this.operationParameterBuilder.withInjectableParameter("someParam", this.STRING_TYPE, true);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] declares a parameter 'someParam' which doesn't exist in the operation 'superOperation'");
    }

    @Test
    public void parameterShouldBeOfSametype() {
        this.operationParameterBuilder.withInjectableParameter("someName", this.NUMBER_TYPE, true);
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] defines a parameter 'someName' of type 'class java.lang.Integer' but in the operation 'superOperation' is of type 'class java.lang.String'");
    }

    @Test
    public void injectConnectionInConnectionLessComponent() throws NoSuchFieldException {
        this.operationParameterBuilder.withConnection(SomeValueProvider.class.getDeclaredField("connection"));
        Mockito.when((Object)this.operationParameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.operationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] defines that requires a connection, but is used in the operation 'superOperation' which is connection less");
    }

    @Test
    public void configurationBasedValueProviderDoesntSupportConnectionInjection() throws NoSuchFieldException {
        this.configrationParameterBuilder.withConnection(SomeValueProvider.class.getDeclaredField("connection"));
        this.mockParameter(this.configrationParameter, this.configrationParameterBuilder);
        Mockito.when((Object)this.configurationModel.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.configrationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] defines that requires a connection which is not allowed for a Value Provider of a configuration's parameter [SomeConfig]");
    }

    @Test
    public void configurationBasedValueProviderDoesntSupportConfigurationInjection() throws NoSuchFieldException {
        this.configrationParameterBuilder.withConfig(SomeValueProvider.class.getDeclaredField("connection"));
        this.mockParameter(this.configrationParameter, this.configrationParameterBuilder);
        Mockito.when((Object)this.configurationModel.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(this.configrationParameterBuilder.build()));
        this.validate();
        this.assertProblems("The Value Provider [SomeValueProvider] defines that requires a configuration which is not allowed for a Value Provider of a configuration's parameter [SomeConfig]");
    }

    @Test
    public void parameterWithValueProviderShouldBeOfStringType() {
        Mockito.when((Object)this.operationParameter.getType()).thenReturn((Object)this.NUMBER_TYPE);
        this.validate();
        this.assertProblems("The parameter [someName] of the operation 'superOperation' is not of String type. Parameters that provides Values should be of String type.");
    }

    private void assertProblems(String errorMessage) {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Problem)errors.get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)errorMessage));
    }

    private void validate() {
        this.valueProviderModelValidator.validate(this.extensionModel, this.problemsReporter);
    }

    private void mockParameter(ParameterModel parameter, ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder builder) {
        Mockito.when((Object)parameter.getModelProperty(ValueProviderFactoryModelProperty.class)).thenReturn(Optional.of(builder.build()));
        Mockito.when((Object)parameter.getModelProperty(ImplementingParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameter.getModelProperty(DeclaringMemberModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameter.getName()).thenReturn((Object)"someName");
        Mockito.when((Object)parameter.getType()).thenReturn((Object)this.STRING_TYPE);
    }

    public class NonInstantiableProvider
    implements ValueProvider {
        private NonInstantiableProvider() {
        }

        public Set<Value> resolve() throws ValueResolvingException {
            return null;
        }
    }

    public static class SomeValueProvider
    implements ValueProvider {
        @Connection
        String connection;

        public Set<Value> resolve() {
            return Collections.emptySet();
        }
    }
}

